[

define_tag:'lp_client_browser',
	-description='Returns a map of the browswer name, browser version, browser type, and browser OS',
	-priority='replace',
	-optional='user_agent';

	// http://www.quirksmode.org/js/detect.html
	// http://en.wikipedia.org/wiki/User_agent
	// http://browsers.garykeith.com/downloads.asp
	// http://www.pgts.com.au/pgtsj/pgtsj0212d.html
	// http://www.pgts.com.au/download/data/robots_list.txt
	// http://www.user-agents.org/index.shtml
	// http://www.robotstxt.org/wc/active/html/contact.html
	// http://www.jafsoft.com/searchengines/webbots.html

	/* Browser types:
	B = Browser
	C = Link/Bookmark/Server Checker
	D = Download/FTP tool
	E = Email Reader
	F = Feed Reader
	L = Library
	O = Offline Browsing
	P = Proxy, Web filter
	R = Robot/Crawler/Spider
	S = Spam Harvester, Bad Bot
	U = Unknown
	V = HTML/CSS/JS Validator
	X = Suspected Robot/Crawler/Spider
	*/

	if: local_defined:'user_agent';
		local:'client_browser' = #user_agent;
	else;
		local:'client_browser' = client_browser;
	/if;
	#client_browser->trim;

	if: #client_browser->size == 0;
		return: (map: 'browser' = 'No User Agent Provided', 'version' = '', 'os' = '', 'type' = 'Suspected Robot/Crawler/Spider', 'typecode' = 'X');
	/if;

	local:'return' = (map: 'browser' = '', 'version' = '', 'os' = '', 'type' = '', 'typecode' = '');


	//-------------------------------------------------------------------
	// browser
	//-------------------------------------------------------------------
	if: #client_browser->(beginswith:'mozilla/');

		iterate: $_lp_client_browser_mozilla, local:'browser';
			if: #client_browser->(contains:#browser->name);
				#return->(insert:'browser' = #browser->value->(get:1));
				#return->(insert:'typecode' = #browser->value->(get:2));
				
				// browser version
				local:'version' = #client_browser->(substring: #client_browser->(find: #browser->name) + #browser->name->size, 255);
				#version = (string_findregexp: #version, -find='\\d[^\\s;()\\]]*');
				if: #version->size;
					#return->(insert: 'version' = #version->(get:1));
				/if;
	
				loop_abort;
			/if;
		/iterate;	

		if: #return->(find:'browser')->size == 0; /// keep trying

			// handle mozilla and old netscape versions, the problem children
			if: !#client_browser->(contains:'compatible') && !#client_browser->(contains:'http') && !#client_browser->(contains:'@') && !#client_browser->(contains:'www');
				local:'mozver' = (string_findregexp: #client_browser, -find='\\d');
				if: #mozver->size;
					#mozver = (integer: #mozver->(get:1));
					if: #mozver < 5 && #client_browser->(contains:'[');
						// old Netscape
						#return->(insert: 'browser' = 'Netscape');
						#return->(insert:'typecode' = 'B');
						
						// browser version
						local:'version' = #client_browser;
						#version = (string_findregexp: #version, -find='\\d[^\\s;()\\]]*');
						if: #version->size;
							#return->(insert: 'version' = #version->(get:1));
						/if;

					else: #mozver == 5 && #client_browser->(contains:'gecko/') && #client_browser->(contains:'rv:');
						if: #client_browser->(split:'gecko/')->last->(split:' ')->size == 1;
							// mozilla
							#return->(insert: 'browser' = 'Mozilla');
							#return->(insert:'typecode' = 'B');
							
							// browser version
							local:'version' = #client_browser->(substring: #client_browser->(find: 'rv:') + 'rv:'->size, 255);;
							#version = (string_findregexp: #version, -find='\\d[^\\s;()\\]]*');
							if: #version->size;
								#return->(insert: 'version' = #version->(get:1));
							/if;

						/if;
						
					/if;

				/if;
			/if;

			// handle msie
			if: #client_browser->(contains:'compatible; MSIE') && !#client_browser->(contains:'http') && !#client_browser->(contains:'@') && !#client_browser->(contains:'www') && !#client_browser->(contains:'.com');
				if: #client_browser->(split:')')->last->size == 0;
					#return->(insert: 'browser' = 'Internet Explorer');
					#return->(insert:'typecode' = 'B');

					// browser version
					local:'version' = #client_browser->(substring: #client_browser->(find: 'MSIE') + 'MSIE'->size, 255);;
					#version = (string_findregexp: #version, -find='\\d[^\\s;()\\]]*');
					if: #version->size;
						#return->(insert: 'version' = #version->(get:1));
					/if;
				/if;
			/if;
		
		/if;

	
	else; // lots of possibilities

		iterate: $_lp_client_browser_other->(find:#client_browser->(get:1)), local:'browser';
			if: #client_browser->(beginswith:#browser->name);
				#return->(insert: 'browser' = #browser->value->(get:1));
				#return->(insert:'typecode' = #browser->value->(get:2));
				// browser version
				local:'version' = #client_browser->(substring: #client_browser->(find: #browser->name) + #browser->name->size, 255);
				#version = (string_findregexp: #version, -find='\\d[^\\s;()\\]]*');
				if: #version->size;
					#return->(insert: 'version' = #version->(get:1));
				/if;
				loop_abort;
			/if;
		/iterate;

	/if;

	//-------------------------------------------------------------------
	// os
	//-------------------------------------------------------------------
	local:'os' = (array:		
								'windows' = 'Windows',
								'win16' = 'Windows',
								'win32' = 'Windows',
								'win64' = 'Windows',
								'win95' = 'Windows',
								'win98' = 'Windows',
								'winNT' = 'Windows',

								'macintosh' = 'Macintosh',
								'darwin' = 'Macintosh',
								'panther' = 'Macintosh',
								'leopard' = 'Macintosh',
								'osx' = 'Macintosh',
								'os x' = 'Macintosh',
								'powerpc' = 'Macintosh',

								'linux' = 'Linux',
								'kanotix' = 'Linux',
								'ubuntu' = 'Linux',
								'mepis' = 'Linux',
								'debian' = 'Linux',
								'suse' = 'Linux',
								'redhat' = 'Linux',
								'red hat' = 'Linux',
								'slackware' = 'Linux',
								'mandrake' = 'Linux',
								'gentoo' = 'Linux',
								'fedora' = 'Linux',

								'solaris' = 'Unix',
								'unix' = 'Unix',
								'bsd' = 'Unix',
								'sun' = 'Unix',
								'irix' = 'Unix',
								'irix' = 'Unix',
								'hpux' = 'Unix',
								'hp-ux' = 'Unix',
								'aix' = 'Unix',
								'sco' = 'Unix',
								'mpras' = 'Unix',
								'reliant' = 'Unix',
								'dec' = 'Unix',
								'sinix' = 'Unix',

								'palm' = 'PalmOS',
								'nintendo' = 'Nintendo',
								'wii' = 'Nintendo',
								'playstation' = 'PlayStation',
								'risc' = 'RISC OS',
								'amiga' = 'Amiga',
								'beos' = 'BeOS',
								'os2' = 'OS/2',
								'os/2' = 'OS/2',
								'webtv' = 'WebTV',
								'xbox' = 'Xbox',

							);

	iterate: #os, local:'o';
		if: #client_browser->(contains:#o->name);
			#return->(insert: 'os' = #o->value);
			loop_abort;
		/if;
	/iterate;



	//-------------------------------------------------------------------
	// if still unknown, see if it has a bot keyword
	//-------------------------------------------------------------------
	if: #return->(find:'typecode') == 'U' || #return->(find:'typecode') == '';
		local: 'bots' = (array:
							'agent',
							'archive',
							'bot',
							'check',
							'crawl',
							'creep',
							'feed',
							'fetch',
							'find',
							'get',
							'grub',
							'index',
							'info',
							'leech',
							'libwww',
							'link',
							'manage',
							'proxy',
							'robo',
							'search',
							'scrub',
							'seek',
							'siphon',
							'site',
							'slurp',
							'spider',
							'url',
							'valid',
							'worm',
		  				);
	
		iterate: #bots, (local: 'bot');
	    	if: #client_browser->(contains:#bot);
				#return->(insert:'browser' = 'Suspected Bot "'+#bot+'"');
				#return->(insert:'typecode' = 'X');
				loop_abort;
			/if;
		/iterate;
	/if;


	//-------------------------------------------------------------------
	// assign the type based on the typecode
	//-------------------------------------------------------------------

	select: #return->(find:'typecode');
		case:'B';
			#return->(insert:'type' = 'Browser');
		case:'C';
			#return->(insert:'type' = 'Link/Bookmark/Server Checker');
		case:'D';
			#return->(insert:'type' = 'Download/FTP tool');
		case:'E';
			#return->(insert:'type' = 'Email Reader');
		case:'F';
			#return->(insert:'type' = 'Feed Reader');
		case:'L';
			#return->(insert:'type' = 'Library');
		case:'O';
			#return->(insert:'type' = 'Offline Browsing');
		case:'P';
			#return->(insert:'type' = 'Proxy, Web filter');
		case:'R';
			#return->(insert:'type' = 'Robot/Crawler/Spider');
		case:'S';
			#return->(insert:'type' = 'Spam Harvester, Bad Bot');
		case:'U';
			#return->(insert:'type' = 'Unknown');
		case:'V';
			#return->(insert:'type' = 'HTML/CSS/JS Validator');
		case:'X';
			#return->(insert:'type' = 'Suspected Robot/Crawler/Spider');
		case;
			#return->(insert:'type' = 'Unknown');
			#return->(insert:'typecode' = 'U');
	/select;

	return: #return;
	
/define_tag;


// browsers with user agents that begin with "mozilla/"
!(global_defined:'_lp_client_browser_mozilla') ? (global:'_lp_client_browser_mozilla') = (array:

	// Gecko browsers
	'iceweasel' = (:'Iceweasel','B'),
	'flock' = (:'Flock','B'),
	'epiphany' = (:'Epiphany','B'),
	'firefox' = (:'Firefox','B'),
	'beonex' = (:'Beonex','B'),
	'camino' = (:'Camino','B'),
	'chimera' = (:'Chimera','B'),
	'galeon' = (:'Galeon','B'),
	'k-meleon' = (:'K-Meleon','B'),
	'k-ninja' = (:'K-Ninja','B'),
	'kazehakase' = (:'Kazehakase','B'),
	'iceape' = (:'Iceape','B'),
	'multizilla' = (:'MultiZilla','B'),
	'netscape' = (:'Netscape','B'),
	'seamonkey' = (:'SeaMonkey','B'),
	'bonecho' = (:'Firefox','B'),
	'firebird' = (:'Firefox','B'),
	'phoenix' = (:'Firefox','B'),
	'granparadiso' = (:'Firefox','B'),
	'minefield' = (:'Firefox','B'),
	// netscape and mozilla handled below

	// MSIE browsers
	'america online' = (:'AOL','B'),
	'aol' = (:'AOL','B'),
	'opera' = (:'Opera','B'),
	'avant' = (:'Avant','B'),
	'crazy browser' = (:'Crazy Browser','B'),
	'maxthon' = (:'Maxthon','B'),
	'NetCaptor' = (:'NetCaptor','B'),
	'myie2' = (:'MyIE2','B'),
	// msie handled below

	// KHTML browsers
	'safari' = (:'Safari','B'),
	'konqueror' = (:'Konqueror','B'),
	'shiira' = (:'Shiira','B'),
	'omniweb' = (:'OmniWeb','B'),
	'cheshire' = (:'Cheshire','B'),
	'netnewswire' = (:'NetNewsWire','B'),

	// Other browsers
	'icab' = (:'iCab','B'),
	'oregano' = (:'Oregano','B'),
	'amigavoyager' = (:'AmigaVoyager','B'),
	'ibrowse' = (:'IBrowse','B'),

	// email readers
	'thunderbird' = (:'Thunderbird','E'),
	'Mnenhy' = (:'Mnenhy Thunderbird Plug-in','E'),

	// proxies
	'BorderManager' = (:'Novell BorderManager','P'),	

	// link checkers
	'LinksManager.com' = (:'LinksManager.com','C'),
	'www.euro-directory.com' = (:'www.euro-directory.com','C'),
	'ZyBorg' = (:'ZyBorg','C'),

	// offline
	'MSIECrawler' = (:'MSIE Offline Favorites','O'),

	// robots
	'AbiLogicBot' = (:'AbiLogicBot','R'),
	'AnyApexBot' = (:'AnyApexBot','R'),
	'Arachmo' = (:'Arachmo','R'),
	'Ask Jeeves' = (:'Ask Jeeves','R'),
	'BecomeBot' = (:'BecomeBot','R'),
	'B-l-i-t-z-B-O-T' = (:'BlitzBOT','R'),
	'BlitzBOT' = (:'BlitzBOT','R'),
	'B_L_I_T_Z_B_O_T' = (:'BlitzBOT','R'),
	'Cerberian Drtrs' = (:'Cerberian Drtrs','R'),
	'FDSE robot' = (:'FDSE robot','R'),
	'Fluffy the spider' = (:'www.searchhippo.com','R'),
	'FurlBot' = (:'FurlBot','R'),
	'Girafabot' = (:'Girafabot','R'),
	'Googlebot' = (:'Googlebot','R'),
	'grub-client' = (:'grub.org','R'),
	'HTTrack' = (:'HTTrack offline browser utility','O'),
	'Larbin' = (:'Larbin','R'),
	'MojeekBot' = (:'MojeekBot','R'),
	'MuscatFerret' = (:'MuscatFerret','R'),
	'scan4mail' = (:'scan4mail anti-spam tool','C'),
	'Scrubby' = (:'Scrubby','R'),
	'SEOChat::Bot' = (:'SEOChat::Bot','R'),
	'Shoula robot' = (:'Shoula robot','R'),
	'slurp@inktomi' = (:'inktomi.com','R'),
	'Teoma' = (:'Ask Jeeves','R'),
	'VoilaBot' = (:'VoilaBot','R'),
	'Vonna.com' = (:'Vonna.com','R'),
	'www.galaxy.com'  = (:'Galaxy.com','R'),
	'Yahoo! Slurp' = (:'Yahoo!','R'),
	'YahooSeeker' = (:'Yahoo!','R'),
	'Zealbot' = (:'Zealbot','R'),


	// spam bots
	'Indy Library' = (:'Delphi/C++ library used mostly by Asian spammers','S'),


);


// browsers with user agents that don't begin with "mozilla/"
!(global_defined:'_lp_client_browser_other') ? (global:'_lp_client_browser_other') = (map:
	'!' = (array:
		'!Susie' = (:'!Susie','C'),
		),
	'&' = (array:
		'<a href=\'http://www.unchaos.com' = (:'UnCHAOS search robot','R'),
		'<b> UnChaosBot' = (:'UnCHAOS search robot','R'),
		'<http://www.sygol.com' = (:'Sygol Search (Italy) robot','R'),
		),
	'(' = (array:
		'(DreamPassport' = (:'DreamCast DreamPassport browser','B'),
		'(Privoxy' = (:'Privoxy web proxy','P'),
		'(Robots.txt Validator' = (:'SearchEngineWorld\'s robots.txt validator','C'),
		),
	'*' = (array:
		'*/Nutch' = (:'Unknown Yahoo robot','R'),
		),
	'+' = (array:
		'+SitiDi' = (:'SitiDi.net search (Germany) robot','R'),
		),
	'-' = (array:
		'-DIE-KRAEHE' = (:'Die Kraehe Meta-Search-Engine (Germany) link checking','R'),
		),
	'1' = (array:
		'123spider' = (:'123spider.de (Germany) web directory link checking','C'),
		'192.com' = (:'192.com - UK web directory','R'),
		'1st ZipCommander' = (:'1st ZipCommander Net - IE based browser','B'),
		),
	'2' = (array:
		'2Bone' = (:'2Bone online link checker','C'),
		),
	'4' = (array:
		'4anything.com' = (:'4Anything robot','R'),
		),
	'8' = (array:
		'8484 Boston Project' = (:'Unknown guestbook spamming or harvesting tool from diff. IPs','S'),
		),
	':' = (array:
		':robot' = (:'neofonie search robot Germany','R'),
		),
	'a' = (array:
		'A-Online' = (:'A-Online.at robot - now Jet2Web Search','R'),
		'A1 Keyword' = (:'A1 Keyword Research - search engine and keyword optimization software','C'),
		'A1 Sitemap' = (:'MiggiBot website crawler engine - A1 Sitemap Generator','R'),
		'ABACHOBot' = (:'ABACHOBot','R'),
		'ABCdatos' = (:'ABCdatos - Castilian program & tutorial directory','R'),
		'Aberja' = (:'Aberja Hybridsuchmaschine (Germany) link checking','R'),
		'abot' = (:'Nameprotect copyright search robot (24.177.134.x)','R'),
		'About' = (:'About robot','R'),
		'Accelatech' = (:'Accela Technology RSS feed crawler','F'),
		'accoona' = (:'Accoona Search robot','R'),
		'Ace Explorer' = (:'Ace Explorer - IE based browser','B'),
		'Ack' = (:'Ackerm search robot','R'),
		'AcoiRobot' = (:'Acoi picture finder robot','R'),
		'Acoon' = (:'Acoon.de robot','R'),
		'Acorn' = (:'Acorn Search Project','R'),
		'ActiveBookmark' = (:'LibMaster.com Active Bookmark HTML page creator','C'),
		'Activeworlds' = (:'Activeworlds 3D homepage browser','B'),
		'Ad Muncher' = (:'Ad Muncher - banner killer','P'),
		'Adaxas' = (:'website directory adaxas link checking','C'),
		'Advanced Browser' = (:'Avant Browser - IE based browser','B'),
		'AESOP' = (:'Aesop robot','R'),
		'agadine' = (:'Agada search (Germany) robot','R'),
		'Agent-Shareware' = (:'SharewarePlaza link checking','R'),
		'AgentName' = (:'Linkomatic submission verifier','R'),
		'AIBOT' = (:'21seek.com (China) robot (218.17.90.xxx)','R'),
		'AideRSS' = (:'AideRss - Postrank RSS and Blog filtering','C'),
		'aipbot' = (:'Nameprotect copyright search robot (24.177.134.x)','R'),
		'Aladin' = (:'Aladin robot','R'),
		'Aleksika' = (:'Aleksika Danmark - Search engine optimization spider','R'),
		'AlkalineBOT' = (:'Vestris robot','R'),
		'Allesklar' = (:'Allesklar.de robot','R'),
		'Alligator' = (:'Alligator download manager','D'),
		'AltaVista' = (:'Altavista robot','R'),
		'Amaya' = (:'Amaya','R'),
		'Amfibibot' = (:'Amfibibot','R'),
		'amibot' = (:'amibot - Amidalla search engine robot (62.241.33.xx)','R'),
		'Amiga-AWeb' = (:'AWeb Amiga browser','B'),
		'AmigaVoyager' = (:'Voyager - Amiga browser','B'),
		'amzn_assoc' = (:'Amazon.com robot for checking their affiliate sites','C'),
		'AnnoMille' = (:'Annomille Italian historical oriented robot','R'),
		'annotate_google' = (:'annotate Google - Firefox extension for annotating Google search results','B'),
		'Anonymized by ProxyOS' = (:'Megaproxy user','P'),
		'Anonymizer' = (:'Anonymizer.com','P'),
		'AnswerBus' = (:'AnswerBus','R'),
		'AnswerChase' = (:'AnswerChase','R'),
		'ANTFresco' = (:'ANT Fresco Browser','B'),
		'antibot' = (:'Antibot (discontinued) robot','R'),
		'AnzwersCrawl' = (:'Anzwers (Yahoo) Australia robot','R'),
		'Apexoo Spider' = (:'Apexoo Search spider','R'),
		'Aplix HTTP' = (:'JavaOS app. for SEGA Saturn Internet and Sanyo Internet-TV','B'),
		'Aplix_SANYO_browser' = (:'JavaOS app. for Sanyo Internet-TV','B'),
		'Aplix_SEGASATURN_browser' = (:'JavaOS app. for SEGA Saturn Internet','B'),
		'Aport' = (:'Aport robot','R'),
		'Appie' = (:'Appie','R'),
		'ArabyBot' = (:'Araby search - Arabia','R'),
		'Arachnoidea' = (:'Euroseek spider','R'),
		'aranhabot' = (:'Amazon.com robot for checking their affiliate sites','C'),
		'ArchitextSpider' = (:'Excite spider','R'),
		'archive.org' = (:'Heritrix - The Internet Archive\'s open-source crawler (207.241.225.2xx)','R'),
		'Argus' = (:'Simpy Bookmarklet crawler (69.55.233.xx)','C'),
		'Arikus' = (:'Arikus inContext search engine software','R'),
		'arianna.libero.it' = (:'arrianna.libero.it','R'),
		'Asahina-Antenna' = (:'ASAHINA Antenna information detecting agent','R'),
		'ask.24x.info' = (:'Ask 24x Info robot','R'),
		'AskAboutOil' = (:'Ask About Oil - Petroleum related search (24.227.212.xxx) using Nutch','R'),
		'asked' = (:'askEd! / Inferret search (Japan) robot using Nutch','R'),
		'ASPSeek' = (:'ASPSeek search engine software -Yahoo-Inc. / Telecom Canada robot','R'),
		'ASSORT' = (:'Associative Sort robot','R'),
		'asterias' = (:'Singingfish media spider (64.12.186.2xx) via AOL search','R'),
		'AtlocalBot' = (:'Atlocal local business search robot','R'),
		'Atomz' = (:'Atomz robot','R'),
		'atSpider' = (:'atSpider (ceased) email harvester / spambot','S'),
		'Attentio' = (:'Attentio social media monitoring and analysing','R'),
		'AU-MIC' = (:'Samsung SPH-A660 phone with Sprint software','B'),
		'augurfind' = (:'Augurnet Swiss (was www.augurnet.ch) search robot','R'),
		'augurnfind' = (:'Augurnet Swiss (was www.augurnet.ch) search robot','R'),
		'autoemailspider' = (:'Auto Email Pro Email harvester','S'),
		'autohttp' = (:'Linkscan tool from Elsop','C'),
		'AV Fetch' = (:'Altavista robot ??','R'),
		'Avant Browser' = (:'Avant Browser - IE based browser','B'),
		'AVSearch' = (:'National Research Council Canada robot','R'),
		'AWeb' = (:'AWeb Amiga browser','B'),
		'axadine' = (:'Axada search Germany robot','R'),
		'AxmoRobot' = (:'Axmo search robot','R'),
		'Azureus' = (:'Azureus Java BitTorrent Client','D'),
		),
	'b' = (array:
		'BaboomBot' = (:'BaBoom Web Portal (ODP) robot (66.98.254.xx)','R'),
		'BackStreet Browser' = (:'BackStreet Browser - Offline browser / website downloader','D'),
		'Baiduspider' = (:'Baiduspider','R'),
		'BanBots' = (:'Project BanBots Perl script robot','C'),
		'Barca' = (:'Barca Pro email & PIM software','B'),
		'BDFetch' = (:'Brandimensions Brand Protection robot','R'),
		'BDNcentral' = (:'Bdncentral Sitesearch robot','R'),
		'BeamMachine' = (:'beammachine web directory (Germany) link checking','R'),
		'beautybot' = (:'Beauty robot for Cosmoty - German beauty and wellness search','R'),
		'BebopBot' = (:'A Passion for Jazz music related search robot','R'),
		'BeebwareDirectory' = (:'LinkcheckerBeepware (site is down) web directory link checking','C'),
		'Big Brother' = (:'Big Brother link checking tool','C'),
		'Big Fish' = (:'GoonGee.com link popularity checking','C'),
		'BigClique' = (:'BigClique Search robot','R'),
		'BIGLOTRON' = (:'Biglotron search (France) robot','R'),
		'Bigsearch' = (:'Bigsearch.ca search robot','R'),
		'Bilgi' = (:'Bilgi.com (Beta) search robot - Turkey','R'),
		'Bimbot' = (:'Bimbot','R'),
		'Bitacle' = (:'Bitacle Blog Search Archive robot','R'),
		'Biyubi' = (:'Biyubi Navigator - Mexican browser for Fenix OS','B'),
		'BlackBerry7520' = (:'Blackberry Wireless Internet browser via Google WAP Proxy','P'),
		'BlackWidow' = (:'BlackWidow web site scanner / downloading tool','D'),
		'Blaiz-Bee' = (:'Blaiz Enterprises RawGrunt search','R'),
		'BlitzBOT@tricus.net' = (:'Blitzsuche Germany robot','R'),
		'BlitzBOT' = (:'BlitzBOT','R'),
		'BlockNote' = (:'BlockNote web page editor','B'),
		'BlogBot' = (:'blogdex robot from MIT.edu','R'),
		'BlogBridge' = (:'BlogBridge RSS reader','B'),
		'Bloglines' = (:'Bloglines','F'),
		'BlogMap' = (:'FeedMap / BlogMap geo coding service','C'),
		'Blogpulse' = (:'Intelliseek\'s BlogPulse blog search','R'),
		'blogsearchbot' = (:'Art of Computing blog search project','R'),
		'BlogSearch' = (:'IceRocket Web search robot','R'),
		'BlogsNow,' = (:'BlogsNow realtime link tracker robot','R'),
		'blogWatcher' = (:'blogWatcher robot from Okumura Group Tokyo (131.112.182.xxx)','R'),
		'BlogzIce' = (:'IceRocket Web search robot','R'),
		'Bloodhound' = (:'Balihoo - Search Engine for Advertising Media','R'),
		'bluefish' = (:'Bluefish HTML-editor for Linux','B'),
		'BMLAUNCHER' = (:'Bookmark Express bookmark manager','C'),
		'boitho' = (:'Boitho search (Norway) robot via 80.202.212.xx / 80.80.111.xx','R'),
		'Bookdog' = (:'Bookdog - Mac bookmark manager','C'),
		'Bookmark Buddy' = (:'Bookmark Buddy - favorite bookmark manager','C'),
		'Bookmark Renewal' = (:'Favourites managing program','C'),
		'BravoBrian' = (:'BravoBrian bSTOP parental control','P'),
		'BruinBot' = (:'Webarchive Project Bruinbot crawler','R'),
		'BSDSeek' = (:'Inktomi (Hotbot-Lycos NBCi) robot','R'),
		'BStop' = (:'BravoBrian bSTOP parental control','P'),
		'btbot' = (:'btbot','R'),
		'BuildCMS' = (:'BuildCMS crawler - market monitoring project of BuildCMS','R'),
		'Bulkfeeds' = (:'Bulkfeeds: RSS directory link checking','C'),
		'BullsEye' = (:'BullsEye/Intelliseek robot','R'),
		'BunnySlippers' = (:'Microsoft server information robot (see link)','C'),
		'BurstFind' = (:'BurstFind search crawler (64.34.172.xx)','R'),
		'Buscaplus' = (:'Buscaplus (Spain) robot','R'),
		'BW-C' = (:'Logitech Desktop Managers (LDM) Backweb (BW) update check','D'),
		),
	'c' = (array:
		'carleson' = (:'Cosmix project crawler (204.14.48.x / 38.113.234.xxx)','R'),
		'Carnegie_Mellon' = (:'Carnegie Mellon University WebBOT','R'),
		'Catall Spider' = (:'Catall.de search & web directory (Germany)','R'),
		'CazoodleBot' = (:'UIUCs Cazoodle search based on MetaQuerier','R'),
		'ccubee' = (:'Empyreum Ccubee (Czech) search engine solution','R'),
		'CE-Preload' = (:'Cisco Content Engine','P'),
		'Ceramic Tile' = (:'Floortransformed.com robot (link ckecking ??)','R'),
		'cfetch' = (:'Cosmix project crawler (204.14.48.x / 38.113.234.xxx)','R'),
		'Charon' = (:'Charon Amiga download manager','D'),
		'Checkbot' = (:'Checkbot link validation','C'),
		'CheckLinks' = (:'Checklinks - Perl link checker','C'),
		'CheckWeb' = (:'CheckWeb link validation','C'),
		'China Local' = (:'Unknown spam bot from telekom.com.my (218.111.83.xxx)','S'),
		'ChristCRAWLER' = (:'Christcentral.com Christcrawler (was www.christcrawler.com)','R'),
		'CipinetBot' = (:'CipinetBot -Cipinet Search Engine Web Crawler','R'),
		'CJ Spider' = (:'Commision Junction link checking spider','C'),
		'CJB.NET' = (:'CJB Net anonymous socks proxy service (216.194.70.x)','P'),
		'ClariaBot' = (:'Claria (ex Gator) SearchScout robot (64.152.73.xx)','R'),
		'Claymont' = (:'Claymont Search robot','R'),
		'CloakDetect' = (:'Seznam Search (Czech Republic) robot','R'),
		'Clushbot' = (:'Clush clustered search robot','R'),
		'CoBITSProbe' = (:'Proposed Content-Based Image Tracking System (CoBITS) P2P crawler','R'),
		'Cocoal.icio.us' = (:'Cocoal.icio.us','R'),
		'ColdFusion' = (:'Cold Fusion server used by various IPs i.e.: - NetWORLD web catalogue link checking','L'),
		'collage.cgi' = (:'WebCollage Syndicator graphics crawler/collector','R'),
		'combine' = (:'Combine harvesting & indexing robot','R'),
		'cometrics' = (:'cometrics Web Content Mining solution - Germany','R'),
		'Commerce Browser Center' = (:'Wildsoft Germany (closed) Internet client system user-agent (was www.oskarweb.de)','B'),
		'complex_network_group' = (:'UCLA Complex Networks Groups Complex Network Analysis','C'),
		'Computer_and_Automation' = (:'Hungarian Academy of Sciences data mining search','R'),
		'Comrite' = (:'ComRite Chinese Search Engine for Oversea Web Sites (69.248.26.xx)','R'),
		'ContactBot' = (:'Probably E-Mail harvesting robot - same as LMQueueBot','S'),
		'Contact' = (:'Probably E-Mail harvesting robot','S'),
		'ContentSmartz' = (:'ContentSmartz e-mail harvesting tools','S'),
		'contype' = (:'Internet Explorer versions 4.x and 5 plugin content','B'),
		'Convera' = (:'Converas RetrievalWare Internet Spider (63.241.61.x)','R'),
		'CoolBot' = (:'Suchmaschine21 (Germany) robot','R'),
		'CoralWeb' = (:'Coral Content Distribution Network','P'),
		'cosmos' = (:'cosmos','R'),
		'Coteo' = (:'Coteo.com - local French directory link checking','C'),
		'CougarSearch' = (:'Cougarsearch.com robot','R'),
		'Cowbot' = (:'Naver Japan / Korea robot','R'),
		'CrawlConvera' = (:'Converas RetrievalWare Internet Spider','R'),
		'Crawler admin@crawler.de' = (:'Crawler.de / Abacho robot','R'),
		'crawler@alexa.com' = (:'Alexa crawler','R'),
		'CrawlerBoy' = (:'Pinpoint WAP search robot','R'),
		'Crawler' = (:'Cometsystems Comet Search robot via Findwhat (now Miva)','R'),
		'Crawllybot' = (:'Crawlly Beta search - Germany (72.232.194.2xx)','R'),
		'CreativeCommons' = (:'Creatice Commons using Nutch open source robot','R'),
		'CrocCrawler' = (:'Croccrawler robot','R'),
		'csci_b659' = (:'Web mining project from CSCI 659 (computer science course) at Indiana Univerity','R'),
		'CSE HTML' = (:'CSE HTML Validator','V'),
		'CSSCheck' = (:'CSSCheck','V'),
		'Cuam' = (:'Cuam - IE based browser','B'),
		'Cuasarbot' = (:'Cuasar (Spain) music / ringtone search spider','R'),
		'curl' = (:'Curl file transferring tool','D'),
		'CurryGuide' = (:'CurryGuide UK link check robot','R'),
		'Custo' = (:'Custo web site spidering tool (link checking)','C'),
		'Custom Spider' = (:'Bisnisseek (was www.bisnisseek.com) robot','R'),
		'Cyberdog' = (:'Cyberdog Mac Browser (was www.cyberdog.org)','B'),
		'CyberSpyder' = (:'CyberSpyder Link Test software','C'),
		'CydralSpider' = (:'Cydral image & site search spider','R'),
		'Cynthia' = (:'Cynthia','V'),
		),
	'd' = (array:
		'DA' = (:'Downloadaccelerator download manager','D'),
		'DataCha0s' = (:'Unknown bot from Kornet Korea (218.149.129.xxx) scans for Perl Awstats','S'),
		'DataFountains' = (:'INFOMINE/iVia Scholary Internet Resource Collections robot','R'),
		'DataparkSearch' = (:'DataparkSearch','R'),
		'DataSpear' = (:'DataSpear Directory robot (24.109.29.xx)','R'),
		'DatenBot' = (:'Sicher-durchs-Netz German security related search (62.75.220.xxx)','R'),
		'DaviesBot' = (:'Wholeweb robot','R'),
		'daypopbot' = (:'Daypop blog - weblog - online mag search spider','R'),
		'dbDig' = (:'dbDig search engine','R'),
		'DBrowse' = (:'Some site scanning tool via diff. IPs i.e.: - wanweb.net (208.6.163.xxx) - cox.net (68.4.xxx.xxx)','S'),
		'DC-Sakura' = (:'DC-Sakura download manager','D'),
		'dCSbot' = (:'unknown divine/Openmarket.com robot','R'),
		'DDD' = (:'some (website) downloading tool','D'),
		'de.searchengine' = (:'Searchengine.com (Germany) submission checking / robot (84.73.57.xx)','R'),
		'DeadLinkCheck' = (:'DLC Perl HTTP link checking','C'),
		'Deep Link' = (:'Sootle Web Directory deep link checker','C'),
		'deepak' = (:'deepak-USC/ISI robot from USC/Information Science Institute','R'),
		'DeepIndex' = (:'Deepindex robot','R'),
		'del.icio.us' = (:'del.icio.us picture robot for thumbnail preview via Yahoo','D'),
		'DeleGate' = (:'DeleGate application level gateway / proxy server','P'),
		'Demo Bot' = (:'Some site scanning tool from 68.154.96.xx (bellsouth.net)','S'),
		'Denmex' = (:'Denmex Websearch robot/link checking','R'),
		'Der gro' = (:'DataBecker Bilder Sauger (discontinued) web graphics downloader','D'),
		'dev-spider2.searchpsider.com' = (:'Searchspider.com robot (72.245.225.xxx)','R'),
		'DiaGem' = (:'DiaGem Japan web crawler','R'),
		'DiamondBot' = (:'DiamondBot','R'),
		'Diamond' = (:'Claria (ex Gator) SearchScout robot (64.152.73.xx)','R'),
		'Digger' = (:'Diggit! robot','R'),
		'DigOut4U' = (:'OpenPortal4U robot','R'),
		'DIIbot' = (:'Findsame.com (site is offline) / Digital-Integrity robot','R'),
		'dillo' = (:'Dillo','B'),
		'DISCo Pump' = (:'DISCo Pump offline browser / website ripper','D'),
		'DittoSpyder' = (:'Ditto picture search robot','R'),
		'dlman' = (:'some download agent','D'),
		'dloader' = (:'Naver Japan / Korea robot','R'),
		'DoCoMo' = (:'NTT DoCoMo (Japan) robot','R'),
		'DocZilla' = (:'DocZilla - Mozilla-based SGML/XML/HTML- browser','B'),
		'dodgebot' = (:'unknown robot from AGMLAB Information Technologies (Information retrieval system ?)','R'),
		'DomainsDB.net' = (:'DomainsDB.net MetaCrawler','R'),
		'DonutP' = (:'Donut P - Japanese IE based browser','B'),
		'Download Demon' = (:'Download Demon/Netzip download manager','D'),
		'Download Druid' = (:'Download Druid IE plugin download manager','D'),
		'Download Express' = (:'Download Express download manager','D'),
		'Download Master' = (:'Download Master download manager','D'),
		'Download Ninja' = (:'Download Ninja download manager (Japan)','D'),
		'Download Wonder' = (:'Download Wonder download manager','D'),
		'Download-Tipp' = (:'Download-Tipp Germany link checking','R'),
		'Download.exe' = (:'download.exe .NET based downloading tool','D'),
		'Dragonfly' = (:'Dragonfly CMS - Open Source content management system','B'),
		'Drecombot' = (:'Drecom Japan (210.233.67.xxx) - Blog search ??','R'),
		'Drupal' = (:'Drupal - open source content management platform','C'),
		'DSurf' = (:'Some site scanning tool via diff. IPs i.e.: - cox.net (68.5.xxx.xxx) - pacbell.net (64.16x.xxx.xxx)','S'),
		'DTAAgent' = (:'DTAAgent Java object for data collecting','R'),
		'dtSearchSpider' = (:'dt Search Spider software','R'),
		'Dual Proxy' = (:'Fourelle Venturi proxy server','P'),
		'Dumbot' = (:'DumbFind.com robot','R'),
		),
	'e' = (array:
		'e-sense' = (:'Vigiltech e-Sense user research robot (website is offline)','R'),
		'e-SocietyRobot' = (:'e-Society Project (Japan) crawler (133.9.238.xx)','R'),
		'EARTHCOM' = (:'Earthcom (Czech Republic) search robot (194.108.39.xx)','R'),
		'EasyDL' = (:'Keywen Encyclopedia Bot','R'),
		'EBrowse' = (:'Some site scanning tool via diff. IPs i.e.: - swbell.net (65.66.xxx.xxx)','S'),
		'eCatch' = (:'eCatch (now Wysigot) offline browser','D'),
		'EchO!' = (:'Echo.fr robot','R'),
		'Educate Search' = (:'Some site scanning tool via diff. IPs i.e.: - cox.net (68.4.xxx.xxx)','S'),
		'egothor' = (:'Xdefine text search engine robot - based on Egothor open source crawler','R'),
		'EgotoBot' = (:'Egoto Search robot','R'),
		'ejupiter' = (:'eJupiter searcg robot (206.191.49.xx)','R'),
		'EldoS TimelyWeb' = (:'TimelyWeb web page monitoring tool','C'),
		'elfbot' = (:'Elftales crawler for uChoose theme based search (Germany)','R'),
		'ELI' = (:'DAUMOA - RSS search robot of Daum','R'),
		'elinks' = (:'ELinks','B'),
		'emailsiphon' = (:'EmailSiphon','S'),
		'EmailWolf' = (:'Trellian EMailWolf E-mail collector','S'),
		'EmeraldShield' = (:'EmeraldShield.com WebBot','R'),
		'EMPAS_ROBOT' = (:'Empas search Korea robot (220.95.22x.xxx)','R'),
		'endo' = (:'endo - Mac news site and blog aggregator','B'),
		'Enfish' = (:'Enfish Personal search tool','R'),
		'enigma' = (:'Enigma','B'),
		'Enterprise_Search' = (:'Enterprise Search engine software (64.202.165.xxx)','R'),
		'envolk' = (:'Envolk Web Search robot','R'),
		'EroCrawler' = (:'EroCrawler adult search robot','R'),
		'ES.NET' = (:'Enterprise Search engine software (64.202.165.xxx)','R'),
		'eseek-larbin' = (:'ExactSEEK (Jayde Online) robot','R'),
		'ESISmartSpider' = (:'ESI Smart-Spider toolkit','R'),
		'EsperanzaBot' = (:'EsperanzaBot','R'),
		'eStyleSearch' = (:'e-Style ISP search (Russia) robot (217.174.103.xxx)','R'),
		'ESurf' = (:'Some site scanning tool via diff. IPs','S'),
		'EuripBot' = (:'Eurip.com - European Internet Portal robot','R'),
		'EvaalSE' = (:'Evaal Search Engine robot','R'),
		'eventax' = (:'Eventax event search (Germany)','R'),
		'Everest-Vulcan' = (:'Vulcan Inc. Everest crawler (in development)','R'),
		'everyfeed-spider' = (:'everyfeed-spider','F'),
		'Exabot' = (:'Exabot','R'),
		'ExactSearch' = (:'eXact Search Bar for IE','B'),
		'exactseek' = (:'ExactSEEK (Jayde Online) robot (69.9.181.1xx)','R'),
		'Exalead' = (:'Exalead (France) search robot (193.47.80.xx)','R'),
		'Excalibur' = (:'Excalibur (now Convera) spider software','R'),
		'Execrawl' = (:'Execrawl software search using nutch','R'),
		'ExperimentalHenrytheMiragoRobot' = (:'Mirago UK Robot','R'),
		'Expired Domain Sleuth' = (:'Expired Domain Sleuth domain name tool','R'),
		'Express WebPictures' = (:'Express Web Pictures image browser','D'),
		'ExtractorPro' = (:'Extractor Pro e-mail collector','S'),
		'Extreme Picture' = (:'Exisoftware image grabber and downloading tool','D'),
		'EyeCatcher' = (:'Download-Tipp Germany robot','R'),
		),
	'f' = (array:
		'Factbot' = (:'Factbites search robot','R'),
		'FaEdit' = (:'FaEdit Professional - Japanese bookmark manager','C'),
		'FairAd' = (:'FairAd user','P'),
		'FANGCrawl' = (:'Safe-t.net web filtering service','P'),
		'FARK.com' = (:'Drew Curtis\' FARK.com link checking','C'),
		'Fast Crawler' = (:'FAST Crawler','R'),
		'FAST Enterprise' = (:'FAST Crawler','R'),
		'FAST FirstPage' = (:'FAST Crawler','R'),
		'FAST MetaWeb' = (:'FAST Crawler','R'),
		'Fast PartnerSite Crawler' = (:'Fast/Alltheweb crawler (66.151.181.xx)','R'),
		'FAST-WebCrawler' = (:'FAST Crawler','R'),
		'fastbot' = (:'Fastbot search Germany crawler (80.252.104.1xx)','R'),
		'FastBug' = (:'Ay-Up geo sync search robot','R'),
		'FastCrawler' = (:'Fast/Alltheweb crawler (66.151.181.xx)','R'),
		'FastSearch' = (:'Fast/Alltheweb crawler used by SuperPages.com','R'),
		'FavIconizer' = (:'FavIconizer - IE favorites icons refreshing tool','D'),
		'favicon finder' = (:'IconSurf.com - Visual Surf Engine','R'),
		'favicon monitor' = (:'IconSurf.com - Visual Surf Engine','R'),
		'favo.eu' = (:'favo.eu (Germany) search robot','R'),
		'FavOrg' = (:'ZD\'s FavOrg favourites managing program','C'),
		'Favorites Sweeper' = (:'Favorites Sweeper bookmark checker','C'),
		'Faxobot' = (:'FaXo Search robot (69.152.89.xx)','R'),
		'FDM' = (:'Free Download Manager (FDM) download accelerator','D'),
		'Feed Seeker' = (:'RSS Feed Seeker bot (68.225.95.2xx)','R'),
		'Feed24' = (:'Feed24 news feed and blog search','R'),
		'Feed::Find' = (:'Feed::Find - Syndication feed (RSS/Atom) auto-discovery','D'),
		'Feedable' = (:'Feedable beta web based RSS service','B'),
		'FeedChecker' = (:'Unknown robot from the University of Tokyo (157.82.157.xx)','R'),
		'Feedfetcher-Google' = (:'Google Feedfetcher - RSS and Atom feed crawler','R'),
		'FeedForAll' = (:'FeedForAll RSS feed robot','C'),
		'Feedshow' = (:'FeedShow online RSS feed reader','B'),
		'Feedster Crawler' = (:'Feedster RSS feed search','R'),
		'FeedZcollector' = (:'FeedZcollector - Feed (RSS, ATOM and RDF) capturing software','B'),
		'Felix' = (:'MixCat robot','R'),
		'fetch libfetch' = (:'FreeBSD download tool','D'),
		'FFC Trap' = (:'Frequent Finders spider via Sitefusion.com','R'),
		'Filangy' = (:'Filangy search and bookmark service','R'),
		'fileboost' = (:'File Boost Network link checking','R'),
		'FileHound' = (:'FileHound download manager','D'),
		'FindAnISP' = (:'Find An ISP robot','R'),
		'Findexa' = (:'Yelo.no business search (Norway) via Findexa','R'),
		'FindLinks' = (:'FindLinks','R'),
		'FineBot' = (:'Finesearch robot','R'),
		'Finjan' = (:'Finjan Vital Security Web Appliance security solution','P'),
		'Firefly' = (:'Fireball.de robot','R'),
		'Firefox' = (:'Unknown robot from Czech Technical University Prague (147.32.141.xx)','R'),
		'FirstGov' = (:'AT&T/Fast Search robot for FirstGov (U.S.Government) portal','R'),
		'firstsbot' = (:'Firstsfind Germany robot / link checking','R'),
		'Flapbot' = (:'Flaptor information retrieval solutions robot','R'),
		'FlashGet' = (:'JetCar/FlashGet download manager','D'),
		'FLATARTS' = (:'FlatArts Favorites Icon Tool','C'),
		'FlickBot' = (:'DivX.com Movie Find robot','R'),
		'flunky' = (:'Metacarta / Cogent robot','R'),
		'flyindex' = (:'FLY Index Metasearch link checking','C'),
		'FocusedSampler' = (:'IBM\'s Almaden Research robot','R'),
		'Fooky' = (:'Fooky search Scorpionbots robot (65.12.170.xxx)','R'),
		'Francis' = (:'Neomo Search (Germany) robot (85.10.197.1xx)','R'),
		'Franklin Locator' = (:'Some spam bot','S'),
		'free-downloads' = (:'Free Downloads shareware directory link checking','C'),
		'FreeFind' = (:'FreeFind.com robot','R'),
		'FreshDownload' = (:'Fresh Download download manager','D'),
		'FreshNotes' = (:'FreshNotes - music related artist search (72.3.225.xx)','R'),
		'FSurf' = (:'Some site scanning tool via diff. IPs','S'),
		'Full Web Bot' = (:'Some site scanning tool from diff. IPs i.e.: - 66.28.240.xx (cogentco.com) - 68.5.174.xx (cox.net)','S'),
		'FunnelWeb' = (:'FunnelWeb','R'),
		'FuseBulb' = (:'FuseBulb search','R'),
		'FyberSpider' = (:'FyberSpider','R'),
		),
	'g' = (array:
		'g2crawler' = (:'g2crawler','R'),
		'Gagglebot' = (:'Some user from bbnplanet.net (4.63.218.2xx) using an Innerprise robot tool','R'),
		'GAIS Robot' = (:'Seed Search robot','R'),
		'Gaisbot' = (:'Gaisbot','R'),
		'GalaxyBot' = (:'Galaxy robot (63.121.41.xxx)','R'),
		'Gallent' = (:'Gallent Search directory (UK)','R'),
		'gamekitbot' = (:'Gamekit game search engine - Germany','R'),
		'Gamespy' = (:'GameSpyHTTP/1.0','D'),
		'GammaSpider' = (:'GammaWare GammaSpider','R'),
		'gazz' = (:'nttrd.com / Infobee.ne.jp robot','R'),
		'Generic Mobile Phone' = (:'Google Mobile Search crawler','R'),
		'Generic' = (:'Unknown','R'),
		'geniebot' = (:'GenieKnows.com search','R'),
		'GeonaBot' = (:'Geona Search robot / link checking','R'),
		'geourl' = (:'GeoURL ICBM Address Server - a location-to-URL reverse directory','C'),
		'GetBot' = (:'Getbot web downloading tool / site grabber','D'),
		'GetRight' = (:'GetRight download manager','D'),
		'GetWeb' = (:'GetWeb - web page to email service','D'),
		'GhostRouteHunter' = (:'Sixxs Ghost Route Hunter','C'),
		'gigabaz' = (:'GigaBaz Brainbot (Germany) robot','R'),
		'Gigabot' = (:'Gigabot','R'),
		'GNODSPIDER' = (:'www.gnod.net spider','R'),
		'Go!Zilla' = (:'Go!Zilla download manager','D'),
		'Go-Ahead-Got-It' = (:'GotIt web accelerator (discontinued)','P'),
		'Goblin' = (:'GoGuides.Org (195.226.137.xx) robot','R'),
		'GoForIt' = (:'GoForIt Search robot','R'),
		'GoGuides' = (:'GoGuides.org directory & search link checking','C'),
		'GoldenFeed' = (:'GoldenFeed.com - RSS search engine','C'),
		'Goldfire' = (:'Invention Machines Goldfire Server','P'),
		'gonzo1' = (:'suchen.de German local search robot','R'),
		'Google Talk' = (:'Google instant messenger','B'),
		'Googlebot' = (:'Googlebot','R'),
		'GrapeFX' = (:'Grapeshot web search system API','R'),
		'GreatNews' = (:'GreatNews 1.0 Beta RSS reader','B'),
		'GreenBrowser' = (:'GreenBrowser - IE based browser (China)','B'),
		'Gregarius' = (:'Gregarius','F'),
		'gridwell' = (:'search gridwell favicon display','D'),
		'GrigorBot' = (:'Grigor Search bot','R'),
		'Gromit' = (:'Australasian Legal Information Institute (AustLII) robot','R'),
		'grub' = (:'Grub open source crawler','R'),
		'gsa-crawler' = (:'Google Search Appliance robot (216.239.xx.xx)','R'),
		'GSiteCrawler' = (:'GSiteCrawler','R'),
		'Guestbook Auto Submitter' = (:'Guestbook spamming tool','S'),
		'Gulliver' = (:'Northernlight robot','R'),
		'Gulper Web Bot' = (:'Yuntis Collaborative Web Resource Categorization and Ranking Project robot','R'),
		'GurujiBot' = (:'guruji : the Indian search engine robot','R'),
		),
	'h' = (array:
		'HappyFunBot' = (:'Happy Fun Search robot','R'),
		'Harvest-NG' = (:'Harvest-NG web crawler used by search.yahoo.com','R'),
		'Haste' = (:'Haste - web mapping and monitoring system','R'),
		'Hatena Antenna' = (:'Hatena::Antenna Japan robot','R'),
		'Hatena Mobile Gateway' = (:'Hatena Japan proxy for handheld/mobile clients','P'),
		'Hatena Pagetitle Agent' = (:'Hatena Japan robot','R'),
		'Hatena RSS' = (:'Hatena Japan RSS feed robot','R'),
		'HatenaScreenshot' = (:'Hatena::Diary (Japan) web page screenshot robot','R'),
		'HeinrichderMiragoRobot' = (:'Mirago Germany robot','R'),
		'Helix' = (:'Helix - The SiteSearch (Canada) web crawler','R'),
		'HenriLeRobotMirago' = (:'Mirago France robot','R'),
		'HenrytheMiragoRobot' = (:'Mirago search (UK) robot','R'),
		'Hi! I\'m CsCrawler' = (:'University of Kassel Germany CsCrawler using the HTTPClient library','R'),
		'HiDownload' = (:'HiDownload download manager','D'),
		'Hippias' = (:'Hippias robot','R'),
		'HitList' = (:'Pilot Hitlist web analytics solution','R'),
		'Hitwise' = (:'Hitwise spider','R'),
		'hl_ftien_spider' = (:'hl_ftien_spider','R'),
		'holmes' = (:'Onet.pl (Poland) search robot','R'),
		'HomePageSearch' = (:'HomePageSearch robot','R'),
		'Homerbot' = (:'Homerweb search robot','R'),
		'Honda-Search' = (:'Honda-Search.com - Honda cars related search robot','R'),
		'HooWWWer' = (:'HooWWer - Next Generation Information Retrieval robot','R'),
		'HotJava' = (:'HotJava browser plus HTML Component 1.1.x','B'),
		'Hotzonu' = (:'Hotzuno - Japanese BBS reader client','B'),
		'HPL/Nutch' = (:'Unknown robot from HP Labs','R'),
		'htdig' = (:'htdig','R'),
		'Html Link Validator' = (:'Lithops Software link validation tool','C'),
		'HTML2JPG' = (:'HTML2JPG webpage to image converter','D'),
		'HTMLParser' = (:'HTMLParser','V'),
		'HTTP Retriever' = (:'PHP HTTP client to access Web servers','D'),
		'http://Anonymouse.org' = (:'Anonymous web proxy service','P'),
		'http://Ask.24x.Info' = (:'Ask 24x Info (Germany) DMOZ related robot','R'),
		'http://www.almaden.ibm.com' = (:'IBM Almaden Research Center','R'),
		'http://www.istarthere.com' = (:'Istarthere.com search robot','R'),
		'http://www.monogol.de' = (:'Monogol - German open source search engine project (195.226.167.1xx)','R'),
		'http://www.trendtech.dk' = (:'TrendTech Search Engine (Denmark) robot','R'),
		'HTTP::Lite' = (:'HTTP::Lite - Standalone Perl module for retreiving HTTP documents','D'),
		'httpget' = (:'httpget','D'),
		'HTTPResume' = (:'HTTPResume Amiga download manager','D'),
		'httpunit' = (:'HttpUnit - Java browser behavior simulation tool','B'),
		'HyperEstraier' = (:'Hyper Estraier full-text search system','D'),
		),
	'i' = (array:
		'i1searchbot' = (:'i1search robot','R'),
		'ia_archiver' = (:'Alexa / The Internet Archive (209.237.238.1xx)','R'),
		'IAArchiver' = (:'Alexa / The Internet Archive (209.237.238.1xx)','R'),
		'iaskspider2' = (:'Iask search / Sina portal robot (China)','R'),
		'ibrowse' = (:'IBrowse','B'),
		'icab' = (:'iCab','B'),
		'ICC-Crawler' = (:'Knowledge Clustered Group ICC-Crawler (University of Tokyo - Japan)','R'),
		'iCCrawler' = (:'ICJobs - Intelligence Competence Center (Germany) robot','R'),
		'ICE Browser' = (:'ICE Java browser','B'),
		'ichiro' = (:'ichiro','R'),
		'IconSurf' = (:'Iconsurf.com - Visual Surf Engine / favicon finder','R'),
		'ICOO Loader' = (:'icooLoader download manager','D'),
		'ICRA_label' = (:'ICRA (Internet Content Rating Association) label spider','R'),
		'icsbot' = (:'ICS Robot Search Engine (International Christian school of Seoul)','R'),
		'IDA' = (:'Internet Download Accelerator','D'),
		'ideare' = (:'Janas (Ideare.com / Tiscali.it) robot','R'),
		'IEFav' = (:'Some bookmark manager','C'),
		'iGetter' = (:'iGetter download manager','D'),
		'IIITBOT' = (:'Webkhoj - Indian language search engine','R'),
		'ilial' = (:'Ilial Knowledge Search robot','R'),
		'IlseBot' = (:'Ilse Netherlands robot (62.69.178.xx)','R'),
		'IlTrovatore' = (:'Il Trovatore - Italian search engine robot','R'),
		'ImageVisu' = (:'ImageVisu image and graphics viewer - display files from the Web (HTTP and ECWP)','B'),
		'IncyWincy' = (:'Look.com robot using IncyWincy search engine','R'),
		'IndexTheWeb.com' = (:'Index the Web (69.57.134.xx) crawler','R'),
		'Industry Program' = (:'Spam bot from diff. IPs','S'),
		'InelaBot' = (:'inelegant.org','R'),
		'Inet library' = (:'Inet Library Resource Center robot','R'),
		'info@pubblisito.com' = (:'Pubblisito.com search - Italia','R'),
		'infoConveraCrawler' = (:'Converas RetrievalWare Internet Spider (63.241.61.x)','R'),
		'InfoFly' = (:'Versions-project.org Ingelin spider','R'),
		'InfoLink' = (:'InfoLink link checking tool','C'),
		'INFOMINE' = (:'INFOMINE Scholary Internet Resource Collection crawler','R'),
		'InfoSeek' = (:'Infoseek robot','R'),
		'InfoWizards' = (:'Reciprocal Link System PRO','C'),
		'INGRID' = (:'Ilse Netherlands robot (62.69.178.xx)','R'),
		'Inktomi' = (:'Inktomi (Hotbot-Lycos NBCi etc.) robot','R'),
		'InnerpriseBot' = (:'Enterprise Search engine software (64.202.165.xxx)','R'),
		'Insitor' = (:'Insitor Search robot (80.67.20.1xx)','R'),
		'InstallShield DigitalWizard' = (:'download manager','D'),
		'Interarchy' = (:'Interarchy file transfer software - SFTP/FTP client for Mac OS X','D'),
		'Internet Ninja' = (:'Dream Train (Japan) Internet search robot','R'),
		'InternetArchive' = (:'Heritrix - The Internet Archive\'s open-source crawler based on Nutch (207.241.225.2xx)','R'),
		'InternetLinkAgent' = (:'Internet Link Agent - link checking tool','C'),
		'InternetSeer' = (:'Internetseer Web site monitoring / Claymont robot','R'),
		'intraVnews' = (:'intraVNews - Feed reader & RSS aggregator for Outlook','B'),
		'IP2LocationBot' = (:'IP2Location - Reverse lookup geographical data and ISP by IP','R'),
		'IP2MapBot' = (:'IP2Map - geographical IP mapping','R'),
		'IPiumBot' = (:'Laurions Ipium robot','R'),
		'IpselonBot' = (:'Ipselon Web Search robot','R'),
		'Iria' = (:'Iria download manager','D'),
		'IRLbot' = (:'IRLbot','R'),
		'Irvine' = (:'Irvine downloading tool','D'),
		'ISC Systems' = (:'Unknown spambot / harvester from diff. IPs','S'),
		'iSiloX' = (:'iSiloX document converter for iSilo reader','B'),
		'IssueCrawler' = (:'IssueCrawler','R'),
		'isurf' = (:'Unknown University of Alberta link-checking ?','C'),
		'IUPUI' = (:'Some spam bot from 66.139.78.xx(x)','S'),
		'iVia' = (:'iVia robot - Open source Internet portal & virtual library system software','D'),
		'IWAgent' = (:'BD BrandProtect - brand, company or trademarks online monitoring','R'),
		),
	'j' = (array:
		'J-PHONE' = (:'Proxy message from jp-q.ne.jp','P'),
		'Jabot' = (:'ODIN Directory Japan robot (163.138.95.xx)','R'),
		'Jack' = (:'German Domanova (offline since Feb.02) robot','R'),
		'Jakarta Commons-HttpClient' = (:'Jakarta Commons (Java based) HTTP client','B'),
		'Jambot' = (:'JamBot search robot (70.146.82.xx)','R'),
		'java' = (:'Java','L'),
		'Jayde' = (:'Jayde B2B Search robot (66.28.139.xx)','R'),
		'JBH Agent' = (:'some site downloading tool ? via 61.77.51.xxx','D'),
		'jBrowser' = (:'WAP 2.0 / jBrowser for handhelds','B'),
		'JCheckLinks' = (:'JCheckLinks Java hyperlink validator','C'),
		'Jeode' = (:'Insignias Jeode (PDA) Java platform','B'),
		'Jetbot' = (:'JetEye Search robot (64.62.142.xxx / 64.71.144.xxx)','R'),
		'JetBrains' = (:'Omea RSS -  Atom - newsgroups web page reader','B'),
		'JetCar' = (:'JetCar / Flashget download manager','D'),
		'jigsaw' = (:'W3C_CSS_Validator','V'),
		'JoBo' = (:'Jobo website downloading program','D'),
		'JobSpider' = (:'Finacialbot.com - German (213.61.218.xx) job search JobRoboter','R'),
		'JOC Web Spider' = (:'Jocsoft Web Spider - website downloading tool','D'),
		'JordoMedia' = (:'Jordo Media RSS / Atom feed directory link checking','C'),
		'Journster' = (:'Journster.com RSS/Atom aggregator','C'),
		'JRTS Check' = (:'Check Favorites bookmark checking','C'),
		'JRTwine' = (:'Check Favorites bookmark checking','C'),
		'Jyxobot' = (:'Jyxobot','R'),
		),
	'k' = (array:
		'K-Meleon' = (:'K-meleon browser -  Windows 2000','B'),
		'k2spider' = (:'Verity K2 Spider ( Network search software)','R'),
		'KakleBot' = (:'Kakle ranked metasearch robot','R'),
		'Kapere' = (:'Kapere site grapper / web downloader','D'),
		'Kazehakase' = (:'Kazehakase - Gecko based browser (Japan)','B'),
		'KDDI' = (:'Google WAP Proxy (216.239.33.x)','P'),
		'KE_' = (:'Voila.fr robot','R'),
		'Kenjin Spider' = (:'Kenjin Spider search agent','R'),
		'Kevin http://dznet.com/kevin' = (:'Dznet.com Kevin crawler (link checking ?) via 68.39.148.xx (nj.comcast.net)','R'),
		'Kevin http://websitealert.net/kevin' = (:'Website AlertsKevin crawler (website monitoring) via 68.39.148.xx (nj.comcast.net)','R'),
		'KFSW-Bot' = (:'Some Perl search script from KFSW (Germany)','R'),
		'kinja' = (:'kinja weblog search robot','R'),
		'KIT-Fireball' = (:'Fireball search (Germany) robot','R'),
		'Klondike' = (:'Klondike WAP Browser','B'),
		'KnowItAll' = (:'University of Washington KnowItAll - web information extraction','R'),
		'Knowledge.com' = (:'The knowledge.com (ODP) directory robot','R'),
		'Kontiki' = (:'Kontiki Client download manager','D'),
		'Krugle' = (:'Krugle source code search engine for developers (64.71.164.1xx)','R'),
		'KSbot' = (:'KnowledgeStorm technology industry crawler for Findtech.com','R'),
		'kuloko' = (:'Kuloko contextual search robot','R'),
		'kulturarw' = (:'National Library of Sweden Heritage Project robot','R'),
		'KummHttp' = (:'Link or server checking from Sanoma Budapest (195.70.35.xxx)','C'),
		),
	'l' = (array:
		'Lachesis' = (:'Intels Lachesis web site response time monitoring tool','C'),
		'LapozzBot' = (:'LapozzBot','R'),
		'Larbin' = (:'Larbin','R'),
		'lawinfo' = (:'LawInfo - Lawyer and attorney directory','R'),
		'LECodeChecker' = (:'Linkexchange crawler','R'),
		'LeechGet' = (:'Leechget download manager','D'),
		'LEIA' = (:'Gseek.com (site is offline) robot','R'),
		'LetsCrawl' = (:'Maybe logfile spamming for Lets crawl! search (Germany)','S'),
		'LexiBot' = (:'Lexibot (exMataHari) search software','R'),
		'LG' = (:'LG 8138 Mobile Phone browser','B'),
		'Libby' = (:'About.com robot','R'),
		'libcurl-agent' = (:'libcurl\'s (multiprotocol file transfer library) standard user-agent name','D'),
		'LibertyW' = (:'LibertyW search for mobile (France)','R'),
		'libWeb' = (:'Korea Telecom Search robot','R'),
		'libwww-perl' = (:'libwww-perl','L'),
		'Liferea' = (:'Liferea - Linux feed reader','B'),
		'LightningDownload' = (:'Lightning Download manager','D'),
		'Lincoln State' = (:'Some spam bot','S'),
		'Link Valet' = (:'Link Valet','C'),
		'Link Validity Check' = (:'Link Validity Check','C'),
		'link_check' = (:'link check 3 - Perl HTML link checker (from Perl for Web Site Management)','C'),
		'LinkAlarm' = (:'Linkalarm link validation','C'),
		'Linkbot' = (:'Linkbot Pro link checking software','C'),
		'LinkCheck' = (:'Linkcheck - linkchecking tool for Unix/Linux','C'),
		'LinkLint' = (:'Linklint - Perl html link checker','C'),
		'linknzbot' = (:'Linknz - The Kiwi Search Engine (New Zealand)','R'),
		'LinkPimpin' = (:'Link-Pimp web directory link checking','C'),
		'LinkProver' = (:'TafWeb link checking program','C'),
		'links (' = (:'Links','B'),
		'Links - http://gossamer' = (:'Gossamer Links','C'),
		'Links 2.0 (http://gossamer' = (:'Gossamer Links','C'),
		'Links SQL' = (:'Links SQL directory management program','R'),
		'Links4US,' = (:'Links4us ODP based directory link checking','C'),
		'LinkScan' = (:'Shareware robot from Elsop.com (used by Indiafocus/Indiainfo and others)','R'),
		'LinksManager' = (:'LinksManager.com','C'),
		'LinkSonar' = (:'LinkSonar (Japan) link checking tool','C'),
		'LinkSweeper' = (:'Left Side Software\'s LinkSweeper (ceased) bookmark utility','C'),
		'LinkWalker' = (:'LinkWalker','C'),
		'ListBidBot' = (:'Listbid.com / Directnic.com link checking ?','R'),
		'Llaut' = (:'llaut robot - Universitat de les Illes Balears (Spain)','R'),
		'LMQueueBot' = (:'E-Mail harvesting robot - same as ContactBot','S'),
		'lmspider' = (:'lmspider','R'),
		'LNSpiderguy' = (:'Lexis-Nexis robot','R'),
		'LocalBot' = (:'LocalBot company information collector','R'),
		'LocalcomBot' = (:'Local.com local search robot (216.52.252.xxx)','R'),
		'Lockstep' = (:'Lockstep (website content protection tool) user agent','R'),
		'Look.com' = (:'GlobalQueue spider (64.40.105.xxx)','R'),
		'Lotus-Notes' = (:'Lotus Notes browser','B'),
		'luchs.at' = (:'Luchs.at (Linux Wiki) link checking','C'),
		'Lunascape' = (:'Lunascape IE based browser (Japan)','B'),
		'lwp-trivial' = (:'lwp-trivial','L'),
		'LWP::Simple' = (:'Perl LWP:Collective module','L'),
		'Lycos' = (:'Lycos spider','R'),
		'lynx' = (:'Lynx','B'),
		),
	'm' = (array:
		'mabontland' = (:'mabontland','R'),
		'Mac Finder' = (:'Some spam bot','S'),
		'Mackster' = (:'UKWizz search robot','R'),
		'MagicWML' = (:'All Magic/Wap wml service for mobile devices','P'),
		'MagpieRSS' = (:'Magpie RSS - PHP RSS Parser','B'),
		'Mail.Ru' = (:'Mail.ru search','R'),
		'mailto:webcraft@bea.com' = (:'Unknown Bea robot','R'),
		'mammoth' = (:'SLI Systems mammoth robot','R'),
		'MantraAgent' = (:'Looksmart robot','R'),
		'MapoftheInternet' = (:'Map of the Internet visual search engine index robot','R'),
		'Mariner' = (:'Kolibri.de robot','R'),
		'Marketwave' = (:'Pilot Hitlist web site analysis','R'),
		'MARTINI' = (:'Looksmart directory page analysis','R'),
		'Marvin' = (:'Marvin Medhunt robot','R'),
		'MaSagool' = (:'Sagool search Japan robot','R'),
		'Mass Downloader' = (:'Mass Downloader download manager','D'),
		'MasterSeek' = (:'Masterseek (Scandinavia) Beta business search ?','R'),
		'Mata Hari' = (:'Lexibot (exMataHari) search software','R'),
		'Matrix S.p.A.' = (:'Virgilio Italy robot (212.48.11.xxx) using Fast Enterprise Search','R'),
		'maxomobot' = (:'Maxomo multimedia search robot','R'),
		'Media Player Classic' = (:'Substitute for Windows Media Player','B'),
		'MediaCrawler' = (:'Media Find crawler','R'),
		'Mediapartners-Google' = (:'Mediapartners-Google','R'),
		'MediaSearch' = (:'WWW.fi Media Search','R'),
		'MegaSheep' = (:'Search UK robot','R'),
		'Mercator' = (:'Mercator crawler software (used by Altavista)','R'),
		'Metaeuro' = (:'MetaEuro.com Clustering Web Search Engine crawler','R'),
		'MetaGer' = (:'MetaGer search robot (Germany)','R'),
		'MetagerBot' = (:'MetaGer search robot (Germany)','R'),
		'MetaProducts Download Express' = (:'Download Express download manager','D'),
		'Metaspinner' = (:'Metaspinner search robot - Germany','R'),
		'metatagsdir' = (:'Metatagsdir.com directory index spider','R'),
		'MFC Foundation Class Library' = (:'Microsoft Foundation Class Library - i.e. used for e-mail harvesting from 68.154.96.xx (bellsouth.net)','S'),
		'MFHttpScan' = (:'Advanced Site Crawler web site ripper and extractor','D'),
		'MicroBaz' = (:'GigaBaz Brainbot (Germany) robot (213.139.152.xx)','R'),
		'Microsoft Data Access Internet Publishing Provider Cache Manager' = (:'MS Office 2000 acting as WebDAV client','P'),
		'Microsoft Data Access Internet Publishing Provider DAV' = (:'MS Office 2000 acting as WebDAV client','B'),
		'Microsoft Data Access Internet Publishing Provider Protocol Discovery' = (:'MS Office 2000 acting as WebDAV client','C'),
		'Microsoft Log Parser' = (:'Microsoft Log Parser text query tool','D'),
		'Microsoft Small Business Indexer' = (:'MS Small Business Server content indexer','R'),
		'Microsoft URL Control' = (:'user agent looks for form-mail components (spam-bot)','S'),
		'Microsoft_Internet_Explorer_5.00.438' = (:'Secure Computing SmartFilterWhere  / Bess web filter (192.55.214.xx)','P'),
		'MIIxpc' = (:'xpc-mii.net HTTP server message','P'),
		'Mindjet MindManager' = (:'The Mindjet blog MindManager category','D'),
		'miniRank' = (:'mini- Rank website popularity tool','C'),
		'Missauga Locate' = (:'Some spam bot','S'),
		'Missigua Locator' = (:'Some spam bot','S'),
		'Missouri College Browse' = (:'Some spam bot','S'),
		'Mister Pix' = (:'Mister PiX picture finding software','D'),
		'Misterbot' = (:'Misterbot search France robot','R'),
		'Miva' = (:'Miva / ex Findwhat.com search robot (66.150.55.2xx)','R'),
		'Mizzu' = (:'Some spam bot from Jasmine Internet - Bangkok (203.147.0.xx)','S'),
		'MJ12bot' = (:'Majestic-12 Web Crawler','R'),
		'Mnogosearch' = (:'Mnogosearch','R'),
		'Mo College' = (:'Unknown bad bot - maybe guestbook spamming or email harvesting','S'),
		'moget' = (:'Goo Japan / Inktomi robot (210.173.179.xx)','R'),
		'mogimogi' = (:'mogimogi','R'),
		'moiNAG' = (:'moiNag - net.art generator','R'),
		'MojeekBot' = (:'MojeekBot','R'),
		'Mojoo' = (:'Mojoo','C'),
		'monkeyagent' = (:'Greasemonkey Firefox extension','D'),
		'MoonBrowser' = (:'Moonbrowser - IE based browser (Japan)','B'),
		'Moreoverbot' = (:'Moreover / FeedDirect RSS feed robot','C'),
		'Morning Paper' = (:'Morning Paper','R'),
		'Morris' = (:'MixCat robot s. also Felix','R'),
		'Motoricerca' = (:'Robots.txt online checker','C'),
		'Mouse-House' = (:'MPRM Group Ltd. Spider Monkey robot','R'),
		'MovableType' = (:'Movable Type  web-based personal publishing system','B'),
		'mozdex' = (:'mozdex','R'),
		'Mozilla (Mozilla@somewhere.com)' = (:'http://www.somewhere.com robot','R'),
		'MQbot' = (:'MetaExplorer project\'s MetaQuerier robot','R'),
		'MQBOT/Nutch' = (:'MetaExplorer project\'s MetaQuerier robot','R'),
		'MSFrontPage' = (:'MS Frontpage 4.x','B'),
		'MSIECrawler' = (:'MSIE Offline Favorites','O'),
		'msnbot' = (:'MSN Search Web Crawler','R'),
		'MSNPTC' = (:'MSN Search robot - 131.107.xxx.xxx 204.95.96.xxx - 204.95.111.xxx 207.46.xxx.xxx','R'),
		'msproxy' = (:'MS Proxy','P'),
		'MSRBot' = (:'Microsoft Research web crawler','R'),
		'Mulder' = (:'StreamBox VCR user agent','D'),
		'multiBlocker' = (:'Multiblocker (Fantomaster) anonymity software user','P'),
		'multicrawler' = (:'MultiCrawler for DERI Galway\'s Semantic Web Search Engine cluster','R'),
		'MultiText' = (:'Virginia Tech Digital Library Research Laboratory robot','R'),
		'MusicWalker' = (:'SoMusical! musical directory link checking','R'),
		'MVAClient' = (:'MVAClient','S'),
		'MyGetRight' = (:'GetRight download manager','D'),
		'Mylinea' = (:'Mylinea France web catalogue crawler','R'),
		'mylinkcheck' = (:'VDOG - SEO webdirecory (Germany) link checking','C'),
		),
	'n' = (array:
		'Naamah' = (:'Blogbot (Germany) robot','R'),
		'NABOT' = (:'Naver Japan / Korea robot','R'),
		'naoFavicon4IE' = (:'naoFavicon4IE','D'),
		'NASA Search' = (:'Unknown spambot / harvester from diff. IPs','S'),
		'NationalDirectory' = (:'Nationaldirectory spider','R'),
		'NaverBot' = (:'Naver Japan / Korea robot','R'),
		'NavissoBot' = (:'Navisso closed beta robot (69.41.162.1xx)','R'),
		'NCSA Beta' = (:'Vias Information Archival robot','R'),
		'Nebullabot' = (:'Nebulla.info distributed crawler (Germany)','R'),
		'NEC Research' = (:'NEC Researchindex robot - now CiteSeer.IST scientific document index','R'),
		'NetAnts' = (:'NetAnts download manager','D'),
		'NETCOMplete' = (:'NetComplete IE browser package','B'),
		'NetinfoBot' = (:'Netinfo.bg search (Bulgaria) robot','R'),
		'NetLookout' = (:'Netlookout internet notifier','R'),
		'Netluchs' = (:'Netluchs (Germany) search (193.164.8.xx)','R'),
		'NetMechanic' = (:'NetMechanic link checker','C'),
		'NetNewsWire' = (:'NewsGator NetNewsWire - Mac RSS feed reader','B'),
		'NetNoseCrawler' = (:'unknown InCom (216.0.107.xx) robot','R'),
		'Netprospector' = (:'Netprospector metasearch software','R'),
		'NetPumper' = (:'Netpumper download manager','D'),
		'NetResearchServer' = (:'NetResearchServer','R'),
		'NetSprint' = (:'Wirtualna Polska / Netsprint search (Poland) robot','R'),
		'NetWhatCrawler' = (:'NetWhat Search crawler (69.9.167.1xx)','R'),
		'NetZippy' = (:'Netzippy robot','R'),
		'NewsGator' = (:'NewsGator online RSS reader','B'),
		'NextGenSearchBot' = (:'Eliyon Crawler for Business People Search','R'),
		'NextopiaBOT' = (:'Nextopia crawler','R'),
		'NG' = (:'Exalead (France) search robot (193.47.80.xx)','R'),
		'nicebot' = (:'nicebot','R'),
		'NICO' = (:'NicoZone childsafe search robot','R'),
		'NITLE Blog' = (:'Experimental LSI (?) robot from 140.233.69.xx (Middlebury.edu)','R'),
		'Nitro Downloader' = (:'Download manager','D'),
		'Noago Spider' = (:'Noago spider','R'),
		'Nokia-WAPToolkit' = (:'Google WAP robot','R'),
		'Nokia7110' = (:'Google WAP proxy','P'),
		'NokodoBot' = (:'Nokodo public beta search robot (67.18.222.xx)','R'),
		'Norbert the Spider' = (:'Burf.com UK Search Engine robot','R'),
		'noxtrumbot' = (:'noxtrumbot','R'),
		'noyona' = (:'Noyona job search (preview)','R'),
		'NP' = (:'Nameprotect copyright search robot (24.177.134.x)','R'),
		'Nsauditor' = (:'Nsauditor Network Security Auditor','S'),
		'NSPlayer' = (:'NetShow Media Player = Windows Media Player 10','B'),
		'nttdirectory' = (:'NTT Directory robot','R'),
		'Nucleus SiteList' = (:'Nucleus CMS SiteList link managing plugin','C'),
		'Nusearch Spider' = (:'Nusearch Spider','R'),
		'Nutch' = (:'Nutch open source robot','R'),
		),
	'o' = (array:
		'obidos-bot' = (:'Weblog bookwatch robot','R'),
		'ObjectsSearch' = (:'Objects Search robot','R'),
		'obot' = (:'obot','R'),
		'Ocelli' = (:'GlobalSpec Engineering Search robot (66.194.55.xxx)','R'),
		'Octopus' = (:'Octopus download manager','D'),
		'Octora' = (:'Octora blog or RSS information crawler - beta (66.228.114.xx)','R'),
		'oegp' = (:'oegp','S'),
		'Offline Explorer' = (:'Offline Explorer','O'),
		'OliverPerry' = (:'Claymont robot / Internetseer Web Site Monitoring','R'),
		'OmniExplorer' = (:'OmniExplorer_Bot','R'),
		'onCHECK' = (:'onsearch.de German web directory link checking','C'),
		'Onet.pl' = (:'onet.pl Szukaj (Search) robot (213.180.128.1xx)','R'),
		'online link validator' = (:'Online Link Validator','C'),
		'Online24' = (:'Online24 shopping portal (Germany) link checking','C'),
		'OntoSpider' = (:'OntoSpider - Dutch robot for a research project. (195.11.244.xx)','R'),
		'Openbot' = (:'Openfind.com.tw robot','R'),
		'Openfind' = (:'Openfind.com.tw robot','R'),
		'OpenISearch' = (:'open i search robot  - search engine in development','R'),
		'OpenTaggerBot' = (:'Opentagger social bookmarking system','R'),
		'OpenTextSiteCrawler' = (:'OpenText crawler','R'),
		'OpenWebSpider' = (:'OpenWebSpider - Open Source web search engine','R'),
		'opera' = (:'Opera','B'),
		'OpidooBOT' = (:'Opidoo Search Belgium robot (62.4.83.xxx)','R'),
		'Oracle Application Server Web Cache' = (:'Oracle Application Server cache','P'),
		'Oracle iMTCrawler' = (:'Oracle interMedia Text - Text and web documents indexing','D'),
		'Oracle Ultra Search' = (:'Oracle Search','R'),
		'OrangeSpider' = (:'Orangeslicer semantic search (Beta) Germany (193.201.52.1xx)','R'),
		'Orbiter' = (:'Orbiter','R'),
		'Orca Browser' = (:'Avant Browser - IE based browser','B'),
		'OSSProxy' = (:'Marketscore (was Netsetter) internet accelerator','P'),
		'Overture-WebCrawler' = (:'Overture/Fast/Alltheweb crawler (66.77.73.xxx)','R'),
		'ozelot' = (:'Ozelot - Flying Cat\'s search engine robot (Germany)','R'),
		),
	'p' = (array:
		'P3P Validator' = (:'P3P Validator','V'),
		'page_verifier' = (:'Secure Computing SmartFilter Tools - malware crawler','R'),
		'PageBitesHyperBot' = (:'PageBitesHyperBot','R'),
		'Pagebull' = (:'Pagebull visual search engine','R'),
		'PagmIEDownload' = (:'Downloadmanager ?','D'),
		'parallelContext' = (:'CFC crawler used by Italian academic and research network (GARR)','R'),
		'ParaSite' = (:'http://www.ianett.com robot','R'),
		'Patwebbot' = (:'Patsearch (Germany) robot','R'),
		'pavuk' = (:'Pavuk web downloading program for Unix','D'),
		'PBrowse' = (:'Some site scanning tool via diff. IPs- i.e.: - cox.net (68.4.xxx.xxx)','S'),
		'pd02' = (:'Post.sk / Eurotel.sk robot','R'),
		'pear' = (:'PEAR','L'),
		'PEERbot' = (:'Peerbot - favicon search robot','R'),
		'PEval' = (:'Some site scanning tool via diff. IPs','S'),
		'php' = (:'PHP','L'),
		'PicoSearch' = (:'Pico Search robot','R'),
		'Piffany' = (:'Piffany targeted search web spider','R'),
		'PigeonBot' = (:'Whois Source domain name information robot (66.249.26.xx)- s.also: - SurveyBot','R'),
		'PingALink' = (:'PingALink website monitoring','R'),
		'Pingdom' = (:'Pingdom web site monitoring','C'),
		'pipeLiner' = (:'pipeline search (DMOZ based) search robot (24.106.39. xxx)','R'),
		'Pita' = (:'Pita crawler','R'),
		'Pizilla Ver' = (:'Private user-agent via Hurricane Electric Internet Services','?'),
		'PJspider' = (:'Portaljuice spider','R'),
		'Plagger' = (:'Plagger - pluggable RSS/Atom feed aggregator written in Perl','B'),
		'PlantyNet' = (:'Plantynet web filtering services - Blacklist DB robot','R'),
		'PluckFeedCrawler' = (:'Pluck RSS feed crawler','R'),
		'Pluggd' = (:'Pluggd Podcast search engine','R'),
		'Pockey' = (:'Yutaka Endo\'s Pockey / GetHTML / GetHTMLW - some downloading tool from Japan','D'),
		'Poirot' = (:'ThePlanet/jaja-jak-globusy.com Google Adsense refferer spam bot from 70.85.116.* / 70.84.128.xxx / 70.85.193.xxx','S'),
		'polybot' = (:'polybot','R'),
		'Pompos' = (:'Pompos','R'),
		'Popdexter' = (:'Popdex - web site popularity crawler','R'),
		'Port Huron Labs' = (:'Unknown spam bot / harvester (63.223.10.***)','S'),
		'PortalBSpider' = (:'PortalB (now Alacra search) spider','R'),
		'portalmmm' = (:'portalmmm IMode mobile browser','B'),
		'PostFavorites' = (:'Yahoo (66.94.237.1xx / 216.109.121.xx) favorites tracking robot','C'),
		'potbot' = (:'Potbot http://sourceforge.net/projects/potbot/: A simple IRC bot written in Perl','R'),
		'PrivacyFinder' = (:'CUPS robot for AT&T Privacy Bird Privacy Preferences (P3P) enhancements','R'),
		'Privoxy' = (:'Privoxy web proxy','P'),
		'Production Bot' = (:'Some site scanning tool from diff. IPs- i.e.: - 67.99.33.x (lightningcon.broadwing.net)','S'),
		'Program Shareware' = (:'Some spam bot','S'),
		'Project XP5' = (:'XP5 robot','R'),
		'PROve AnswerBot' = (:'Answerchase PROve Answerbot','R'),
		'ProWebGuide' = (:'ProWebguide robot','R'),
		'psbot' = (:'psbot','R'),
		'PSurf' = (:'Some site scanning tool via diff. IPs- i.e.: -QWest Net','S'),
		'psycheclone' = (:'Unknown website grabbing / ripping for unknown purposes from 208.66.195.x - Digitalinfinity.org Russia','S'),
		'puf' = (:'Parallel URL Fetcher downloading tool','D'),
		'pulseBot' = (:'WebarooBot - Webaroo web site search / theme based downloading tool (64.124.122.2xx)','R'),
		'PureSight' = (:'PureSight Internet content filter','P'),
		'PuxaRapido' = (:'Puxa Rapido download manager','D'),
		'PycURL' = (:'PycURL','L'),
		'Python-urllib' = (:'Python-urllib','L'),
		),
	'q' = (array:
		'Qango' = (:'Qango.com Web Directory robot','R'),
		'QPCreep' = (:'Quepasa!com (Latin American search) robot','R'),
		'QuepasaCreep' = (:'Quepasa!com (Latin American search) robot','R'),
		'QueryN' = (:'QueryN Metasearch robot','R'),
		'QuickTime' = (:'Quicktime for Macintosh','B'),
		'Qweery' = (:'Qweerybot for the Qweery search engine (in development) - Netherland','R'),
		),
	'r' = (array:
		'rabaz' = (:'gigaBaz - the brainbot (Germany) robot','R'),
		'RaBot' = (:'Daum Korea robot (211.115.109.xxx)','R'),
		'ramBot' = (:'Intersearch.de (was www.intersearch.de) robot (Germany)','R'),
		'RAMPyBot' = (:'RAMPyBot','R'),
		'Rank Exec' = (:'Rank Exec reciprocal link checking','C'),
		'Rational SiteCheck' = (:'Innova/IBM Rational SiteCheck - Rational robot','R'),
		'ReadABlog' = (:'Read A Blog - RSS feed and blog search engine','C'),
		'RealDownload' = (:'RealDownload download manager','D'),
		'Reaper' = (:'Reaper robot for SiteSearch','R'),
		'REBOL View' = (:'REBOL/View - machine independent internet client application','B'),
		'Rebusnet' = (:'Rebusnet software site - link / submission checking','R'),
		'reciprocal links checker' = (:'Online reciprocal link checker','C'),
		'RedBot' = (:'rediff.com search link checking','C'),
		'RedCarpet' = (:'RedCarpet crawler for Pronto price comparison search(66.179.107.1xx)','R'),
		'RedCell' = (:'Der Bot for telegenetic.net\'s security related search (65.220.67.2xx)','R'),
		'RedKernel' = (:'RedKernel Softwares robot','R'),
		'REL Link Checker' = (:'REL Link Checker','C'),
		'Rewebber' = (:'Rewebber proxy service','P'),
		'rico' = (:'Applied Semantics Auto-Categorizer for QWestDex Direct','R'),
		'RixBot' = (:'RixBot Rebol Indexer for the RIX - Rebol related search (195.204.121.xx)','R'),
		'RMA' = (:'Real Media server acting as client','P'),
		'RoboCrawl' = (:'Canadian Content search crawler','R'),
		'RoboPal' = (:'FindPal Australia metasearch robot (61.68.139.xx)','R'),
		'Robot/www.pj-search.com' = (:'PopJapanSearch robot','R'),
		'Robot: NutchCrawler- Owner: wdavies@acm.org' = (:'Experimental robot using Wget via attbi.net','R'),
		'Robot@SuperSnooper.Com' = (:'Supersnooper robot','R'),
		'Robozilla' = (:'Netscape Directory / DMOZ Open Directory link crawler','R'),
		'Rotondo' = (:'Qualigo.de robot','R'),
		'RPT-HTTPClient' = (:'different IPs using the HTTPClient library (mostly link checking)','C'),
		'RRC' = (:'Metacarta.com (66.28.xx.xxx) robot','R'),
		'RssBandit' = (:'RSS Bandit RSS/Atom reader for .NET framework','B'),
		'RSSMicro' = (:'RSS Micro Search - RSS feed search engine','R'),
		'RSSOwl' = (:'RSSOwl embedded RSS feed reader','B'),
		'RssReader' = (:'Ykoon RssReader news feed reader','B'),
		'RSurf15a' = (:'Some site scanning tool via diff. IPs- i.e.: - dslx.net (208.35.1x.xxx) - Home.com','S'),
		'Rubbot' = (:'rubhub blog spider','C'),
		'RufusBot' = (:'RufusBot','R'),
		'RX Bar' = (:'RX (Reflexive Search) Bar for IE','B'),
		),
	's' = (array:
		'S&L Spider' = (:'Search & Links directory spider','C'),
		'S.T.A.L.K.E.R.' = (:'SEO-Tools.net link checking ?','C'),
		'SafariBookmarkChecker' = (:'SafariBookmarkChecker for Mac OS X','C'),
		'SandCrawler' = (:'SandCrawler','R'),
		'savvybot' = (:'WebSavvy Directory robot','R'),
		'SBIder' = (:'SBIder','R'),
		'SBL-BOT' = (:'Softbyte Labs Black Widow web site ripper','D'),
		'ScanWeb' = (:'ScanWeb - regular expression based web page searching tool','R'),
		'ScholarUniverse' = (:'ScholarUniverse - Scholarly experts search robot','R'),
		'schwarzmann.biz' = (:'URL Spider Pro ("USP") used by German Schwarzmann GmbH','R'),
		'Science Traveller' = (:'1X Web Browser','B'),
		'ScollSpider' = (:'WebWobot UK search engine robot (82.43.129.2xx)','R'),
		'Scooter' = (:'Altavista robot','R'),
		'Scope' = (:'Scope Navigator mobile browser (Japan)','B'),
		'ScoutAbout' = (:'Some nec.com robot using Research Republic ScoutAbout Research Tool','R'),
		'scoutmaster' = (:'ScoutMaster information retrieval software','R'),
		'Scrubby' = (:'Scrubby','R'),
		'Search' = (:'URL Search+ search software','R'),
		'Search-Engine-Studio' = (:'Xtreem Search Engine Studio - SE software','R'),
		'search.ch' = (:'Search.ch robot','R'),
		'searchbot admin@google.com' = (:'Unknown robot  / website grabber from Chinatelecom (219.142.78.xxx)','S'),
		'SearchByUsa' = (:'SearchByUSA robot (69.150.7.xxx)','R'),
		'SearchdayBot' = (:'Searchday (Germany) search robot','R'),
		'SearchExpress' = (:'Searchexpress spider','R'),
		'SearchGuild' = (:'Searchguild forum & directory robot (81.3.75.xxx)','R'),
		'Searchit-Now' = (:'Searchit robot (69.93.107.xx)','R'),
		'Searchmee!' = (:'Searchmee!  Search Engine (prototype) robot by findanisp.com','R'),
		'SearchSight' = (:'SearchSight','R'),
		'Searchspider' = (:'SearchSpider robot','R'),
		'SearchTone' = (:'Janas (Ideare.com / Tiscali.it) robot','R'),
		'Seekbot' = (:'Seekbot','R'),
		'Seeker.lookseek.com' = (:'Lookseek search robot / link checking','R'),
		'semaforo.net' = (:'semaforo.net web filtering software','P'),
		'Semager' = (:'Semager.de (was NG-Search) semantic search - Germany','R'),
		'semanticdiscovery' = (:'semanticdiscovery','R'),
		'Sensis' = (:'Sensis Web Crawler','R'),
		'SeznamBot' = (:'Seznam Search (Czech Republic) robot','R'),
		'Shareaza' = (:'Shareaza P2P peer-to-peer download client','D'),
		'SharewarePlazaFileCheckBot' = (:'SharewarePlaza File Check Bot - link checking','R'),
		'Shim Crawler' = (:'Chikayama-Taura Lab Shim-Crawler used for The Kototoi Project (Japan) - (133.11.36.xx)','R'),
		'Shim-Crawler' = (:'Shim-Crawler','R'),
		'ShopWiki' = (:'ShopWiki','R'),
		'Shoula.com Crawler' = (:'Shoula Search Engine crawler','R'),
		'SietsCrawler' = (:'Siets Crawler - Web based site crawling application','R'),
		'Siigle Orumcex' = (:'Siigle search (Turkey) robot','R'),
		'silk' = (:'silk','R'),
		'SimpleFavPanel' = (:'SimpleFavPanel - IE newsfeed panel plugin','B'),
		'Simpy' = (:'Simpy bookmarking and personal search engine','R'),
		'Sirketcebot' = (:'Sirket?e search - Turkey','R'),
		'SiteBar' = (:'SiteBar','C'),
		'sitecheck.internetseer' = (:'Internetseer Web Site Monitoring / Claymont robot','R'),
		'SiteRecon' = (:'SiteRecon website monitoring spider at xx minute intervals','R'),
		'SiteSnagger' = (:'PC Magazin web site downloadmanager','D'),
		'SiteSpider' = (:'Site Spider robot (66.249.17.xx)','R'),
		'SiteSucker' = (:'SiteSucker Mac website downloading tool','D'),
		'SiteTaggerBot' = (:'SiteTagger.com bookmark organizer','C'),
		'SiteTruth.com' = (:'SiteTruth - Automatic site legitimacy rating system','R'),
		'SiteWinder' = (:'Webwasher.com (217.146.159.xx) internet filter','P'),
		'SiteXpert' = (:'Xtreeme SiteXpert sitemap & search engine builder','R'),
		'Skampy' = (:'Skaffe.com directory link checker','R'),
		'Skimpy' = (:'Skaffe.com directory link checker','R'),
		'Skywalker' = (:'Visvo distributed website crawler based on Nutch','R'),
		'Slarp' = (:'Only.com robot','R'),
		'Sleipnir' = (:'Sleipnir - Japanese Explorer based browser & search bar','B'),
		'Slider_Search' = (:'Slider Search directory robot (194.213.194.2xx)','R'),
		'SlimBrowser' = (:'Slim Browser (IE based browser) - uses this user agent for favicon.ico only','B'),
		'Slurp' = (:'Inktomi (Hotbot-Lycos-NBCi) robot','R'),
		'SlySearch' = (:'Slysearch robot (now Turnitin robot)','R'),
		'SmartDownload' = (:'Netzip/Smartdownload download manager','D'),
		'smartwit' = (:'Loop Improvements NRS Enterprise search (69.44.155.xx[x])','R'),
		'SmiffyDCMetaSpider' = (:'SmiffyDCMetaSpider - Robot to check the retro-adding of Dublin Core metadata','R'),
		'snap.com' = (:'Unknown bot from bb2.net (66.234.139.xxx) also as Snapbot/1.0','S'),
		'Snapbot' = (:'Unknown bot from bb2.net (66.234.139.xxx) - also as snap.com','S'),
		'Snappy' = (:'Snappy','R'),
		'Snarfer' = (:'Snarfer RSS reader','B'),
		'snoopy' = (:'Snoopy','L'),
		'SnykeBot' = (:'Snyke.com France robot','R'),
		'SocSciBot' = (:'Link crawler for the social sciences','R'),
		'SoftBank' = (:'NetFront browser on Softbank mobile phone','B'),
		'SoftHypermarketFileCheckBot' = (:'Soft Hypermarket link checking','R'),
		'Softizerbot' = (:'Softizer.com software directory link checking','C'),
		'sogou spider' = (:'sogou spider','R'),
		'Sogou web spider' = (:'Unknown UA from Chinanet (220.181.26.1xx) faking Sogou search robot','S'),
		'sohu agent' = (:'Unknown UA from Chinanet (220.181.26.1xx) faking Sogou search robot','S'),
		'sohu-search' = (:'Sohu (Search Fox) search robot China (61.135.131.xxx)','R'),
		'Space Bison' = (:'Default Proxomitron (discontinued) filtering proxy user agent identifier','P'),
		'SpeedDownload' = (:'Speed Download (Mac) download manager','D'),
		'speedfind' = (:'Speedfind.de robot','R'),
		'Speedy Spider' = (:'Entireweb search robot','R'),
		'Speedy_Spider' = (:'Entireweb search robot','R'),
		'Sphider' = (:'Sphider - a lightweight search engine in PHP','R'),
		'Spida' = (:'Only.com robot','R'),
		'Spider-Sleek' = (:'Search-Info ODP/DMOZ spider','R'),
		'spider.batsch' = (:'Batsch robot','R'),
		'Spider.TerraNautic' = (:'TerraNautic spider for Schnellsuchen touristic search (Germany)','C'),
		'spider.yellopet' = (:'Yellopet spider','R'),
		'Spider/maxbot.com' = (:'Maxbot .gov .mil .edu indexing robot','R'),
		'SpiderKU' = (:'Unknown robot from CPE at Kasetsart University (158.108.35.xxx)','R'),
		'SpiderMan' = (:'Yahoo Search user agent or spider (202.165.102.xxx)','R'),
		'SpiderMonkey' = (:'SpiderMonkey Canada robot','R'),
		'Spinne' = (:'Spider.de robot','R'),
		'Spock Crawler' = (:'Spock - people search application - via Amazon web services','R'),
		'sportsuchmaschine' = (:'Sportsuchmaschine (German sports related search) link checking / robot','R'),
		'sproose' = (:'Sproose personalized search (38.100.225.xx)','R'),
		'SQ Webscanner' = (:'SQ Webscanner Mac download manager','D'),
		'Squid-Prefetch' = (:'Simple page-prefetch for Squid web proxy','P'),
		'squidclam' = (:'Squidclam is a replacement for SquidClamAV-Redirector','P'),
		'SquidClamAV_Redirector' = (:'SCAVR - Squid helper script for scanning download URLs for viruses','P'),
		'Sqworm' = (:'Sqworm','R'),
		'SSurf15a' = (:'Some site scanning tool via diff. IPs i.e.: - choiceone.net (216.153.xxx.xxx) - epix.net (216.108.198.xx)','S'),
		'StackRambler' = (:'StackRambler','R'),
		'Stamina' = (:'Stamina download manager','D'),
		'Star Downloader' = (:'Star Downloader download manager','D'),
		'StarDownloader' = (:'Star Downloader download manager','D'),
		'stat statcrawler@gmail.com' = (:'Experimental search engine spider from 66.92.186.xxx','R'),
		'Steeler' = (:'Steeler crawler','R'),
		'Strategic Board Bot' = (:'Strategic Board blogs and news aggregator robot','R'),
		'Submission Spider' = (:'Surfsafely submission verifier','R'),
		'suchbaer' = (:'Suchbaer.de (Germany) search robot','R'),
		'suchbot' = (:'Suchbot Germany robot','R'),
		'Suchknecht' = (:'Suchknecht Austria robot','R'),
		'suchpadbot' = (:'suchpad search Germany robot (213.239.194.xx)','R'),
		'Sunrise' = (:'Sunrise XP web sites and newsfeeds converter and handheld reader','B'),
		'SuperBot' = (:'SuperBot','O'),
		'Superdownloads' = (:'Ubbi Superdownloads (Brazil) link checking','C'),
		'SURF' = (:'SurfControl Web Filtering','P'),
		'SurferF3' = (:'Wanadoo Rechereche robot','R'),
		'SurfMaster' = (:'Maskbit Surfmaster bookmark tool','C'),
		'SurveyBot' = (:'SurveyBot','R'),
		'suzuran' = (:'Yokogao Search Engine robot (Kanazawa University)','R'),
		'SWB' = (:'HP Secure Web Browser for OpenVMS','B'),
		'Swooglebot' = (:'Swooglebot Swoogle\'s semantic web crawler','R'),
		'SWSBot' = (:'SWSBot - SmartWareSoft (85.186.255.xx) software search engine created for Playfuls.com','R'),
		'SygolBot http://www.sygol.net' = (:'Sygol Search (Italy) robot','R'),
		'Sylera' = (:'Sylera browser (Japan)','B'),
		'SyncIT' = (:'SyncIT link validation','C'),
		'Syndirella' = (:'Syndirella desktop information aggregator (beta)','B'),
		'SynoBot' = (:'Synomia (France) robot','R'),
		'SynooBot' = (:'SynooBot','R'),
		'Syntryx' = (:'Syntryx Solution Suite - domain / keyword crawler (216.7.179.xx)','R'),
		'Szukacz' = (:'Szukacz.pl (Polish search) robot','R'),
		),
	't' = (array:
		'T-Online Browser' = (:'German T-Online browser & internet suite','B'),
		'tags2dir' = (:'tags2dir.com directory index','R'),
		'Tagword' = (:'TAGword DMOZ survey - ODP link checking robot','R'),
		'Talkro' = (:'Daumsoft Talkro IR robot','R'),
		'TAMU_CS' = (:'Texas A&M University - Dept. of Computer Science crawler (server or link checking ?)','R'),
		'targetblaster' = (:'Targetblaster user link validation ?','R'),
		'TargetYourNews' = (:'Target Your News - user submitted links','C'),
		'TCDBOT' = (:'Trinity College Dublin (Ireland) TCDBOT','R'),
		'TECOMAC' = (:'Tecomac Gmbh (Germany) crawler software - now Arexera Information Technologies','R'),
		'Tecomi' = (:'Tecomi (Germany) beta / test robot (84.201.65.xxx)','R'),
		'Teleport' = (:'Teleport (website) downloading tool','D'),
		'Teoma' = (:'Teoma crawler (65.214.36.xx[x])','R'),
		'Teradex Mapper' = (:'Teradex Directory robot','R'),
		'TeragramCrawler' = (:'Teragram multilingual text & data processing software','D'),
		'terraminds-bot' = (:'Terraminds blog search (Germany)','R'),
		'TerrawizBot' = (:'TerrawizBot','R'),
		'Test spider' = (:'Noceans Information Portfolio Manager (66.35.69.x)','R'),
		'TestCrawler/Nutch' = (:'Balihoo - Search Engine for Advertising Media','R'),
		'The Expert HTML Source Viewer' = (:'Expert HTML online source viewer','D'),
		'TheSuBot' = (:'TheSuBot','R'),
		'Thumbnail.CZ' = (:'Thumbnail.CZ','R'),
		'thumbshots-de-Bot' = (:'ThumbShots website thumbnail service (Germany) robot','D'),
		'timboBot' = (:'Breaking Blogs timbo bot blog robot','R'),
		'TimelyWeb' = (:'TimelyWeb web page monitoring tool','C'),
		'tivraSpider' = (:'Tivra spider from AT&T Labs Research','R'),
		'TJG/Spider' = (:'Tjgroup spider','R'),
		'Tkensaku' = (:'Tkensaku Search (Japan) robot from 210.239.46.xxx (www.tken.com)','R'),
		'Topodia' = (:'Topodia search engine and personal information assistant (in development)','R'),
		'TOPOS robot' = (:'Topos search (Russia) robot','C'),
		'Toutatis' = (:'Hoppa robot (81.4.78.xxx)','R'),
		'traazibot' = (:'Traazi! search (Germany) robot','R'),
		'Trampelpfad-Spider' = (:'Trampelpfad Webkatalog spider','R'),
		'tricosMetaCheck' = (:'Tricos meta tag validation','C'),
		'TSurf15a' = (:'some bad user agent','S'),
		'TulipChain' = (:'Tulip Chain browser / link checker for Dmoz.org directory','C'),
		'TurnitinBot' = (:'TurnitinBot','R'),
		'Turnpike Emporium' = (:'TurnPike Emporium Directory (207.67.198.x) link checking','R'),
		'TutorGig' = (:'TutorGig tutorial search robot','R'),
		'Tutorial Crawler' = (:'TutorGig tutorial search robot','R'),
		'Twiceler' = (:'Twiceler experimental web crawler','R'),
		'Twisted PageGetter' = (:'File downloading component from Twisted Python','D'),
		'Twotrees' = (:'Twotrees content filter','P'),
		'TygoBot' = (:'Tygo Search robot','R'),
		'TygoProwler' = (:'Tygo Search robot','R'),
		),
	'u' = (array:
		'UCmore' = (:'UCMore -  IE navigation and search plugin','B'),
		'UdmSearch' = (:'UdmSearch / MySearch (now mnoGoSeach) offline browser/search client','R'),
		'UIowaCrawler' = (:'University of Iowa Crawler- possibly MySpiders','R'),
		'UKWizz' = (:'UKWizz search robot','R'),
		'Ultraseek' = (:'Infoseek robot','R'),
		'Under the Rainbow' = (:'Unknown mail harvester/spambot from 80.58.13.xxx (proxycache.rima-tde.net)','S'),
		'UP.Browser' = (:'Mobile phone browser','B'),
		'updated' = (:'updated','R'),
		'UPG1' = (:'Handspring (PalmOS powered cellphone) Treo Blazer browser','B'),
		'Uptimebot' = (:'UptimeBot.com online link popularity check','R'),
		'URI::Fetch' = (:'URI::Fetch - client for fetching HTTP pages and syndication feeds (RSS Atom)','D'),
		'URL Spider Pro' = (:'Innerprise URL Spider Pro (now ES.NET) web indexing / site searching tool','R'),
		'URLBase' = (:'URLBase - Internet shortcut manager','C'),
		'URLBlaze' = (:'URLBlaze file sharing link toolkit','C'),
		'URLGetFile' = (:'URLGetFile downloading tool','D'),
		'User-Agent:  BoardReader Favicon' = (:'BoardReader search favicon fetcher','D'),
		'User-Agent:  BoardReader Image' = (:'BoardReader search image fetcher','D'),
		'User-Agent:  LjSEEK' = (:'ljpic.com - LiveJournal picture feed search','C'),
		'User-Agent: FileHeap' = (:'FileHeap download manager','D'),
		'User-Agent: Mozilla' = (:'Malformed UA header from some guestbook/forum spammer','S'),
		'user-agent=Mozilla' = (:'unknown robot (reads robots.txt) or sitegrabber. From different IPs- ie.: 62.98.8.xx (wind.it)','R'),
		'USyd-NLP-Spider' = (:'University of Sydney NLP Spider for research in Natural Language Processing','R'),
		'UtilMind HTTPGet' = (:'Web Thief Site Grabber','D'),
		'Utopia WebWasher' = (:'WebWasher ad filter','P'),
		'uTorrent' = (:'?Torrent BitTorrent client','D'),
		),
	'v' = (array:
		'Vagabondo' = (:'WiseGuys robot Netherland - 82.94.216.2','R'),
		'Vakes' = (:'Open Directory link checking from Vakes','R'),
		'vb wininet' = (:'iNet Grabber - Internet content grabber','D'),
		'versus' = (:'Versus Project robot - Comparing methods for near-uniform URL sampling','R'),
		'VeryGoodSearch' = (:'VeryGoodSearch.com link submission checking','R'),
		'Verzamelgids' = (:'Verzamelgids NL link checking robot','R'),
		'Vespa' = (:'Unknown robot from Yahoo Norway','R'),
		'virus_detector' = (:'Sidewinder G2 anti-virus and anti-spyware protection','D'),
		'VisBot' = (:'Visbot crawler for a search software under development','R'),
		'Visicom' = (:'Some IE toolbar made with Visicom Media Dynamic Toolbar software','B'),
		'Vision Research' = (:'Vision research lab\'s Cortina - content based image retrieval (128.111.60.xx)','R'),
		'Vivante Link Checker' = (:'Vivante Link Checker','C'),
		'VLC media player' = (:'VLC - Cross-platform media player and streaming server','B'),
		'VMBot' = (:'VM - Vertical Search Engine (China)','R'),
		'Vortex' = (:'Vortex','R'),
		'voyager' = (:'voyager','R'),
		'VSE' = (:'Vivisimo search crawler (206.210.89.xxx)','R'),
		'vspider' = (:'Verity vspider indexing software','R'),
		'VWBOT' = (:'VWBot - MetaQuerier Crawler for the MetaQuerier project at the University of Illinois','R'),
		'VYU2' = (:'VYU2','R'),
		),
	'w' = (array:
		'W3C-checklink' = (:'W3C-checklink','C'),
		'W3C-WebCon' = (:'WebCon - the Libwww command line tool','D'),
		'W3C_Validator' = (:'W3C_Validator','V'),
		'W3CLineMode' = (:'W3C Line Mode (character based Web browser)','B'),
		'W3CRobot' = (:'Unknown link checking using Libwww via Korea Telecom (221.148.44.xxx)','C'),
		'w3m' = (:'w3m','B'),
		'W3SiteSearch' = (:'W3 Site Search (Germany) search engine solution','R'),
		'wadaino.jp-crawler' = (:'Wadain (Japan) Blog / RSS search crawler','R'),
		'WannaBe' = (:'Wanna-Be text mode browser','B'),
		'WapOnWindows' = (:'WapOnWindows WAP browser for PCs','B'),
		'Watchfire' = (:'Watchfire WebXM intranet solution','P'),
		'WAVcheck' = (:'WAVcheck - Simple Vendor Discovery Tool for detecting client-side tags from web analytics vendors','C'),
		'Wavefire' = (:'Wavefire local search community engine (64.141.15.1xx)','R'),
		'Waypath' = (:'Waypath blog discovery engine robot','R'),
		'WDG_Validator' = (:'WDG_Validator','V'),
		'Web Downloader' = (:'Web Downloader','O'),
		'Web Image Collector' = (:'Datafire.com\'s Web Image Collector (graphics downloading tool)','D'),
		'Web Link Validator' = (:'Relsoft link checking software','C'),
		'Web Snooper' = (:'RankMeter ranking software','R'),
		'web-bekannt' = (:'Web-bekannt German web directory link checking','C'),
		'Web-Bot' = (:'Unkown link or server checking from W?rzburg University Germany (132.187.10.xx)','R'),
		'web2express' = (:'Web2Express / Web2x - Open data searching tool','R'),
		'WebAlta' = (:'WebAlta search Russia crawler (85.21.201.xx)','R'),
		'WebarooBot' = (:'WebarooBot / RufusBot from webaroo offline search service','R'),
		'WebAuto' = (:'Yanasoft WebAuto website copier / downloading tool','D'),
		'webbandit' = (:'Web Bandit personal search software','R'),
		'WebBug' = (:'Amansoft WebBug web server protocol test','C'),
		'Webclipping' = (:'WebClipping.com - online news monitoring service','R'),
		'webcollage' = (:'webcollage','R'),
		'WebCompass' = (:'Quarterdecks WebCompass search tool','R'),
		'WebCopier' = (:'WebCopier','O'),
		'WebCorp' = (:'WebCorp linguistic search engine (UK)','R'),
		'webcrawl' = (:'Webcrawl Search robot (64.40.105.xxx)','R'),
		'WebDownloader' = (:'Unix/Linux Web Downloader','D'),
		'WebFetch' = (:'WingFlyer WebFetch website downloading tool','D'),
		'WebFilter' = (:'Verso NetSpective WebFilter','P'),
		'WebFindBot' = (:'Webfind search robot','R'),
		'Webglimpse' = (:'Webglimpse search engine software','R'),
		'webGobbler' = (:'webGobbler - Online random image generator','R'),
		'WebLight' = (:'WebLight web analyzer & link checker','C'),
		'Weblink\'s checker' = (:'WebLink\'s link management system for HTTP- FTP and Mail hyperlinks','C'),
		'Weblog Attitude Diffusion' = (:'Los Alamos National Laboratoy weblog research project','R'),
		'webmeasurement' = (:'Unknown robot from Leipzig University (Germany) faculty for computer science','R'),
		'WebMiner' = (:'WebMiner bulk file downloader','D'),
		'WeBoX' = (:'WeBoX (Japan) - Browser and web collector','D'),
		'WebPix' = (:'WebPix - picture downloading tool','D'),
		'WebQL' = (:'Caesius WebQL - Custom robot/agent generator / web extraction software','D'),
		'WebRACE' = (:'WebRACE - HTTP retrieval- annotation and caching engine','P'),
		'WebReaper' = (:'Webreaper download manager','D'),
		'WebSauger' = (:'WebSauger download tool?','D'),
		'WebSearch.COM.AU' = (:'Websearch Australia robot','R'),
		'WebSearchBench' = (:'Dortmund University WebSearchBench - Open source search software','R'),
		'Website Explorer' = (:'Web site downloading tool and offline browser (Japan)','D'),
		'Website eXtractor' = (:'Website eXtractor web site downloading tool','D'),
		'WebsiteWorth' = (:'Sootle web directory Website Worth ranking tool','R'),
		'Webspinne' = (:'Webspinne.de robot','R'),
		'Websquash.com' = (:'Websquash.com','R'),
		'WebStat' = (:'WebStat - Java statistical computing environment for the web','R'),
		'Webster' = (:'Webster - Rev. Healeys web crawler','R'),
		'webster-internet' = (:'Websters Webmaster Archive (Germany) submission / pad checking','C'),
		'WebStripper' = (:'WebStripper download manager','D'),
		'WebTrafficExpress' = (:'WebTrafficExpress IBM server software','P'),
		'WebTrends' = (:'Web Trends link analyzer','C'),
		'WebVac' = (:'The Stanford WebBase Project crawler','R'),
		'WebVal' = (:'webval - Python link checking tool','C'),
		'Webverzeichnis' = (:'Webverzeichnis.de (Germany) directory robot','R'),
		'WebVulnCrawl' = (:'Web Vulnerability Crawler','S'),
		'WebWatcherMonitor' = (:'Studio Net.Idea\'s Web Watcher Monitor robot','R'),
		'WebZIP' = (:'WebZIP','O'),
		'Wells Search' = (:'Unknown spam bot / harvester (62.163.**.** / 62.194.**.*)','S'),
		'WEP Search' = (:'Some spam bot- see link','S'),
		'West Wind' = (:'wwIPStuff - Internet client tools for Visual FoxPro','D'),
		'WFARC' = (:'IBM\'s Almaden Research robot (Clever search project)','R'),
		'Wget' = (:'Wget','O'),
		'Whatsup' = (:'Whatsup Gold network monitor','C'),
		'whatUseek' = (:'WhatUSeek / Chubba robot','R'),
		'WhizBang' = (:'WhizBang! Labs (closed since May 2002) information extraction robot','R'),
		'Wildsoft' = (:'some download agent','D'),
		'Willow' = (:'Twotrees crawler','R'),
		'Windows-Media-Player' = (:'Windows Media Player 10','B'),
		'WinGet' = (:'Nicksoft WinGet download manager','D'),
		'WinHTTP Example' = (:'Example code for a WinHTTP C++ library crawler','R'),
		'WinkBot' = (:'Wink beta search robot (64.13.136.x)','R'),
		'WinPodder' = (:'WinPodder - Podcast player and RSS reader','B'),
		'WinWAP' = (:'WinWap - Windows PC WAP browser','B'),
		'Wir sind die Borg' = (:'Yammba web directory (Germany) link checking','C'),
		'WIRE' = (:'WIRE crawler used by the University of Pisa - Italy','R'),
		'WISEbot' = (:'Korea Wisenut robot','R'),
		'WiseWire' = (:'Wisewire domain checker (Discontinued)','R'),
		'wish-project' = (:'WISH academic research project for link checking','C'),
		'WoFindeIch' = (:'WoFindeIch','R'),
		'WordChampBot' = (:'Wordchamp web page vocabulary / translation robot','D'),
		'WordPress' = (:'WordPress personal Blog publishing platform','B'),
		'worio' = (:'WORIO (beta) search for computer scientists and programmers using Heritrix open-source crawler','R'),
		'WorldLight' = (:'Entireweb Search robot (62.13.25.xxx)','R'),
		'WorQmada' = (:'unknown link checking (from 4.18.57.126) ?','C'),
		'Wotbox' = (:'Wotbox spider','R'),
		'WSB' = (:'WebSearchBench crawler from Dortmund University- Germany','R'),
		'wume_crawler' = (:'WUME Lab\'s web crawler (128.180.121.xxx)','R'),
		'Wusage' = (:'Wusage log-file analysis','R'),
		'Wwlib' = (:'WWLib - Wolverhampton Univerity Web Library for classifying web documents','R'),
		'WWSBOT' = (:'WWSBOT web server version checker','C'),
		'WWW-Mechanize' = (:'Perl web page fetching module','D'),
		'www.arianna.it' = (:'Arianna robot','R'),
		'www.business-socket.com' = (:'Business-Socket.com link checking ?','C'),
		'www.doweb.co.uk' = (:'The DoWeb UK Business directory link checking','C'),
		'www4mail' = (:'www4mail - web navigation & database search by e-mail','O'),
		'WWWC' = (:'WWWC Updating check of Web pages. (Japanese only)','C'),
		'WWWster' = (:'Unknown robot from CIS at Munich University (129.187.254.xxx)','R'),
		'WWWeasel' = (:'World Wide Weasel Germany robot','R'),
		'WWWOFFLE' = (:'WWWoffle download manager','D'),
		),
	'x' = (array:
		'X-Crawler' = (:'Arexera (Germany) crawler software','R'),
		'Xaldon' = (:'Xaldon_WebSpider','O'),
		'Xenu' = (:'Xenu Link Sleuth','C'),
		'Xerka' = (:'XerKa text mining and information retrieval software','D'),
		'xine' = (:'xine video player','D'),
		'xirq' = (:'XIRQ search (beta) robot (70.86.206.1xx)','R'),
		'XMLSlurp' = (:'XMLSlurp','R'),
		'XRL' = (:'Metamark URL Shorten Service','P'),
		'xyro' = (:'Inria Crawler','R'),
		),
	'y' = (array:
		'Y!J' = (:'Yahoo Search Japan robot (211.14.8.2xx)','R'),
		'Y!OASIS' = (:'Yahoo picture service for mobiles','P'),
		'Y!TunnelPro' = (:'Y!TunnelPro - Yahoo! Messenger companion user agent','B'),
		'yacy' = (:'yacy','R'),
		'yacybot' = (:'Yacy distributed P2P web search engine robot','R'),
		'Yahoo Pipes' = (:'(Yahoo) Pipes interactive data aggregator robot','R'),
		'Yahoo! Mindset' = (:'Yahoo Mindset: Intent-driven Search (66.228.182.1xx)','R'),
		'Yahoo-Blogs' = (:'Yahoo blog indexing robot (209.191.83.1xx)','R'),
		'Yahoo-MMAudVid' = (:'Yahoo multimedia crawler (206.190.43.xx)','R'),
		'Yahoo-MMCrawler' = (:'Yahoo multimedia crawler via Fastsearch.net (66.77.73.xx)','R'),
		'Yahoo-Test' = (:'Yahoo Search robot','R'),
		'Yahoo-VerticalCrawler-FormerWebCrawler' = (:'Yahoo crawler via Overture (66.77.73.3x)','R'),
		'YahooFeedSeeker' = (:'Yahoo Publisher Network RSS crawler','R'),
		'YahooSeeker' = (:'Yahoo!','R'),
		'Yandex' = (:'Yandex Search Russia link checking (213.180.206.2xx)','R'),
		'yarienavoir.net' = (:'Yarienavoir search (Belgium) robot (217.71.121.xx)','R'),
		'Yeti' = (:'1noon.com search Korea robot (222.231.21.xxx)','R'),
		'yggdrasil' = (:'yggdrasil spider for GoPubMed biorelated search engine','R'),
		'YodaoBot' = (:'Yodao search (China)','R'),
		'yoogliFetchAgent' = (:'yoogliFetchAgent','R'),
		'yoono' = (:'Yoono - community based search (193.110.140.xxx)','R'),
		'YottaCars_Bot' = (:'YottaCars bot - YottaCar car search engine ( 64.62.175.xxx)','R'),
		'YottaShopping_Bot' = (:'YottaShopping bot - YottaShopping search engine ( 64.62.175.xxx)','R'),
		'YTunnelPro' = (:'Y!TunnelPro - Yahoo! Messenger companion user agent','B'),
		),
	'z' = (array:
		'Z-Add Link Checker' = (:'Z-Add online link checker','C'),
		'Zao' = (:'Zao','R'),
		'ZBot' = (:'Zeus Internet Marketing Robot based on Webster Pro component','R'),
		'Zearchit' = (:'Zearchit German search / directory (212.227.109.1xx)','R'),
		'ZeBot' = (:'Ze.bz Moteur de Recherche robot (213.251.135.xx)','R'),
		'zedzo' = (:'ZedZo Search (beta) robot - 24.62.50.1xx','R'),
		'Zend_Http_Client' = (:'Zend PHP frameworks Zend_Http_Client component','D'),
		'zerxbot' = (:'Zerx search robot (138.88.147.xxx) ?','R'),
		'Zeus ThemeSite' = (:'Zeus Internet Marketing Robot (based on Webster Pro)','R'),
		'Zeus xxxxx' = (:'Zeus Internet Marketing Robot (based on Webster Pro)','R'),
		'Zeusbot' = (:'Zeusbot robot for building the Ulsysseek.com index','R'),
		'Zeus' = (:'Zeus email harvester from Asia','S'),
		'Ziggy' = (:'Unknown agent (server- or link checking ?) from 198.173.158.xx','C'),
		'Zippp' = (:'Zipp.net web search robot','R'),
		'Zippy' = (:'Zippyfinder robot','R'),
		'Zoo Tycoon' = (:'Microsoft Zoo Tycoon 2 game client','B'),
		'ZoomSpider' = (:'Zoom Search Engine software spider','R'),
		'zspider' = (:'zspider','R'),
		'ZyBorg' = (:'ZyBorg','C'),
		),
);

]